<?php
/**
 * This file Updates Shipment against Orders
 *
 * @package Joovii Couriersplease Shipping Plugin
 *
 * @link https://joovii.com
 *
 * PHP version : 7.2.1
 */
error_reporting(0);
define('WP_USE_THEMES', false);

if( file_exists('../../../wp-blog-header.php') )
{
	require('../../../wp-blog-header.php');
}
else if( file_exists('/opt/bitnami/wordpress/wp-blog-header.php') )
{
	require('/opt/bitnami/wordpress/wp-blog-header.php');
}
else 
{
	die("File Not Found");
}


// STEP 1 :: GET the proper security codes
$data = file_get_contents('php://input');

if ('' == $data) {
	Joovii_couriersplease_error_exit('Access Token Missing');
}

$inputs = json_decode($data, true);

if (is_array($inputs) && count($inputs)) {
	if (isset($inputs['security_code']) && ''!=$inputs['security_code']) {
		$st = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));
		if (is_array($st) && count($st) ) {
			if (isset($st['accesstoken']) && ''!=$st['accesstoken']) {
				if (md5($inputs['security_code'])!=$st['accesstoken']) {
						Joovii_couriersplease_error_exit('Access Token Mismatch');
				}

				// All Good, Just Update the settings
				if (isset($inputs['settings']) && is_array($inputs['settings'])) {
					$result_arr = array_merge($st, $inputs['settings']);
					$r = update_option('woocommerce_jooviicouriersplease_settings', $result_arr);
					if (false===$r) {
						actionlog('WRITE to WP OPTIONS Failed');
						Joovii_couriersplease_error_exit('Settings Updation Failed');
					} else {
						actionlog('WRITE to WP OPTIONS SUCCESS');
						joovii_couriersplease_success_exit('Settings Updated Successfully');
					}
				}

			} else {
				Joovii_couriersplease_error_exit('Access Token Missing in Woo Store');
			}

		} else {
			Joovii_couriersplease_error_exit('Access Token Missing in Woo Store');
		}

	} else {
		Joovii_couriersplease_error_exit('Access Token Missing in Request');
	}
}

/**
 * This function shows Error messages
 * as API response and ends the execution
 *
 * @param String $msg : Input Message
 *
 * @return void
 */
function Joovii_couriersplease_error_exit($msg) {
	echo json_encode(['err' => 1, 'msg' => $msg]);
	die();
}
/**
 * This function shows Success messages
 * as API response and ends the execution
 *
 * @param String $msg : Input Message
 *
 * @return void
 */
function joovii_couriersplease_success_exit($msg) {
	echo json_encode(['err' => 0, 'msg' => $msg]);
	die();
}
