<?php
add_action( 'add_meta_boxes', 'joovii_couriersplease_meta_boxes' );

function joovii_couriersplease_meta_boxes_setup() {
	add_action( 'add_meta_boxes', 'joovii_couriersplease_meta_boxes' );
}

function joovii_couriersplease_meta_boxes() {

	// For new WOoCommerce
	add_meta_box(
	    'woocommerce-joovii-couriersplease-track-shipment',
		__( 'Joovii Couriersplease Shipment' ),
		'joovii_couriersplease_shipment_options',
		'woocommerce_page_wc-orders',
		'side',
		'high'
	);

	// For OLd WooCOmmerce
	add_meta_box(
	    'woocommerce-joovii-couriersplease-track-shipment',
		__( 'Joovii Couriersplease Shipment' ),
		'joovii_couriersplease_shipment_options',
		'shop_order',
		'side',
		'high'
	);

}

function joovii_couriersplease_shipment_options($order) {
	global $woocommerce, $post;

	$type = get_class($order);
	if($type == 'WP_Post')
	{
		$order_id =  $order->ID;
	}
	else
	{
	    $order_id = $order->get_id();
	}

	if( joovii_couriersplease_check_if_hpos_enabled() )
	{
		$joovii_couriersplease_reference  = $order->get_meta('joovii_couriersplease_reference');
		$joovii_couriersplease_order_id   = $order->get_meta('joovii_couriersplease_order_id');
		$joovii_couriersplease_response   = $order->get_meta('joovii_couriersplease_response');
		$joovii_couriersplease_label_url  = $order->get_meta('joovii_couriersplease_label_url');
	}
	else
	{
		$joovii_couriersplease_reference = get_post_meta($order_id, 'joovii_couriersplease_reference', true);
		$joovii_couriersplease_order_id  = get_post_meta($order_id, 'joovii_couriersplease_order_id', true);
		$joovii_couriersplease_response  = get_post_meta($order_id, 'joovii_couriersplease_response', true);
		$joovii_couriersplease_label_url = get_post_meta($order_id, 'joovii_couriersplease_label_url', true);
	}
	$joovii_couriersplease_setting = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
	$show_popup = 1;
	echo '<ul>';
	//if ('' == $joovii_couriersplease_reference) {
?>
		<li><a class='shipmentSubmitModal' href="#popup1" onclick="setIframe()" style="pointer:cursor"><?php echo esc_html('View Couriersplease Shipment Option'); ?></a></li>
<?php
	//}

	if ('x' == $joovii_couriersplease_reference) {
		$labelsArray = Joovii_couriersplease_get_download_label_link($joovii_couriersplease_order_id);
		foreach ($labelsArray as $kl=>$vl) {
?>
			<li>
				<a href="<?php echo esc_html(admin_url('admin.php?page=download-shipping-label&oid=' . $order_id . '&pdfdlink=' . $vl['size'] )); ?>" target="_blank">
				<?php echo esc_html('Download Shipping Label[size=' . $vl['size'] . ']' ); ?>
				</a>
			</li>
<?php
		}
?>
		<li><a class='shipmentSubmitModal' href="#popup1" onclick="setIframe()" style="pointer:cursor"><?php echo esc_html('View Shipment Details'); ?></a></li>
<?php
	}

	if('' != $joovii_couriersplease_label_url) {
	?>
		<li><br>Shipment has been booked
		<br/>
		<a target='_blank' href='<?php echo esc_url($joovii_couriersplease_label_url);?>'>Download Label</a>
		</li>
	<?php
	}
	echo '</ul>';
	if ( 1== $show_popup ) {
		$shopid  = isset($joovii_couriersplease_setting['shop_id']) ? $joovii_couriersplease_setting['shop_id'] : '';
		$securitycode = isset($joovii_couriersplease_setting['accesstoken']) ? $joovii_couriersplease_setting['accesstoken'] : '';
		$target_url = J_COURIERSPLEASE_JOOVII_WEBAPP_URL . '/shopadmin/oms/orderdetails_new?orderid=' . $order_id . '&mode=normal&refrshcache=no&shopid=' . $shopid . '&securitycode=' . $securitycode ;
		?>
<style>
.overlay {  position: fixed;top: 0;bottom: 0;left: 0;right: 0;background: rgba(0, 0, 0, 0.7);transition: opacity 500ms;visibility: hidden;opacity: 0;z-index:99;}
.overlay:target {visibility: visible;opacity: 1;}
.popup {margin: 100px 0px auto 14%;padding: 10px;  background: #fff;border-radius: 5px;width: 75%;position: relative;transition: all 2s ease-in-out;height: 77%;}
.popup h2 {margin-top: 0;color: #333;font-family: Tahoma, Arial, sans-serif;}
.popup .close {position: absolute;top: 0px;right: 30px;transition: all 200ms;font-size: 30px;font-weight: bold;text-decoration: none;color: #333;}
.popup .close:hover {color: #06D85F;}
.popup .content {max-height: 92%;height: 92%;}
@media screen and (max-width: 700px){ .popup{width: 70%;}}
.popup iframe{width:100%;height:100%;}
</style>

<div id="popup1" class="overlay">
<div class="popup">
<h2>View Quote and Book Shipment</h2>
<a class="close" href="#">&times;</a>
<div class="content">
<iframe id='quoteframe' src=""></iframe>
</div>
</div>
</div>

<script>
var isset = 0;
function setIframe(){
var iframe_url = '<?php echo $target_url; ?>';
if( !isset ){
isset = 1;
jQuery('#quoteframe').attr('src', iframe_url);
console.log('Set the iframe URL once');
}

}
</script>
<?php
	}
}
