<?php
if (!class_exists('WP_List_Table') ) {
		require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}

if ( !class_exists('Joovii_Couriersplease_Loader_WP_List_Table' ) ) {
	class Joovii_Couriersplease_Loader_WP_List_Table {
		/**
		* Start up
		*/
		public function __construct() {
			add_action('admin_menu', array($this, 'Joovii_couriersplease_logs_menu'));
		}

		public function Joovii_couriersplease_logs_menu() {
			$joovii_couriersplease_setting = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));
			if ( isset($joovii_couriersplease_setting['enable_log']) && 'yes' == $joovii_couriersplease_setting['enable_log']) {
				// add submenu items
				
				add_submenu_page('admin.php?page=joovii_couriersplease_logs', 
				     esc_attr__('Joovii Couriersplease Logs Table', 'joovii-couriersplease-shipping'), 
					 esc_html__('Joovii Couriersplease Logs', 'joovii-couriersplease-shipping'), 
					 'manage_options', 
					 'joovii_couriersplease_logs', 
					 array($this, 'Joovii_couriersplease_logs'), 4);
				
				remove_submenu_page('admin.php?page=joovii_couriersplease_logs', 'joovii_couriersplease_logs');
			}
		}

		/**
		* Admin page callback
		*/
		public function Joovii_couriersplease_logs() {
			global $wpdb, $url;
			$url = admin_url('admin.php');
			if ( isset($_REQUEST['logs'] ) ) {	
				if ( 'flush' == $_REQUEST['logs'] ) {
					
					$wpdb->query('TRUNCATE TABLE ' . $wpdb->prefix . 'joovii_courierspleaselogs');
					Joovii_couriersplease_log_actions('LOG Table Cleaned');
					echo '<script>location.href="' . $url . '?page=joovii_couriersplease_logs";</script>';
				}
				
			}
			
			$logs_table = new Joovii_couriersplease_Logs_Table();
			$logs_table->prepare_items();
			
			?>
<div class="wrap">
	<br/>
	<button class="flush" id="flush" onclick="javascript:flush_logs();" >Flush Logs</button>
	</div>
	<div class="wrap">
		<h2>All Joovii Couriersplease Logs</h2>
			<?php
			$logs_table->display();
			?>
</div>
<script> 
function flush_logs() 
{ 
   if( confirm("Are you sure you want to delete all Joovii Couriersplease logs?") )
   { 
      window.location.href = "<?php echo esc_url($url); ?>?page=joovii_couriersplease_logs&logs=flush" ;
   } 
} 
</script>
<?php
		}
	}
}

$Joovii_Couriersplease_Loader_WP_List_Table = new Joovii_Couriersplease_Loader_WP_List_Table();
