<?php
class Joovii_couriersplease_Logs_Table extends WP_List_Table {
	public function __construct() {
		parent::__construct(array('ajax'=>false));       //does this table support ajax?
	}
	/**
	* Add columns to grid view
	*/
	public function get_columns() {
		$columns = array(
			'id'=>'ID',
			//'eventname'=>'Event Name',
			//'orderid'=>'Order Id',
			'logs'=>'Logs',
			'timestamp'=>'Time'
		);
		return $columns;
	}
	public function column_default($item, $column_name) {
		switch ( $column_name ) {
			case 'id':
			//case 'eventname':
			//case 'orderid':
			case 'logs':
			case 'timestamp':
				return $item[$column_name];
			default:
				return print_r( $item, true ) ; //Show the whole array for troubleshooting purposes
		}
	}
	/**
	* Prepare admin view
	*/
	public function prepare_items() {
		global $wpdb;
		$table_name = $wpdb->prefix . 'joovii_courierspleaselogs';
		$per_page = 50;
		$current_page = $this->get_pagenum();
		if (1 < $current_page) {
			$offset = $per_page * ( $current_page-1 );
		} else {
			$offset = 0;
		}

		$srcCon = ' AND 2=2 ';

		$req1 = isset($_GET['q1']) &&
				'' != $_GET['q1'] ?
				wc_clean($_GET['q1'])  :
				'';

		if ('' != $req1) {
			$srcCon .= ' AND logs like \'%' . trim($req1) . '%\' ';
		}

		$req2 = isset($_GET['q2']) &&
				'' != $_GET['q2'] ?
				wc_clean($_GET['q2']) :
				'';

		if ('' != $req2) {
			$srcCon .= ' AND logs like \'%' . trim($req2) . '%\' ';
		}

		$items = $wpdb->get_results(
			$wpdb->prepare(
			'SELECT id, CONCAT(\'<pre>\',logs,\'</pre>\') as logs, timestamp FROM %1s WHERE 1=1 %1s ORDER BY id DESC LIMIT %d OFFSET %d;', $table_name, $srcCon, $per_page, $offset),
			ARRAY_A
		);

		$columns = $this->get_columns();

		$this->_column_headers = array($columns);

		$count = $wpdb->get_var(
			$wpdb->prepare('SELECT COUNT(id) FROM ' . $table_name. ' WHERE 1=1 %1s ', $srcCon)
		);

		$this->items = $items;
		// Set the pagination
		$this->set_pagination_args(array('total_items'=>$count,'per_page'=>$per_page,'total_pages'=>ceil($count/$per_page)));
	}
}
