<?php
function JooviiCouriersplease_export_order_in_bulk() {
	
	global $wpdb, $table_prefix;

	$error = 0;
	$message = "";
	
	$nonce = isset($_REQUEST['_wpnonce']) ? sanitize_text_field($_REQUEST['_wpnonce']) : '';

	if ( '' != $nonce && ! wp_verify_nonce( $nonce, 'joovi-wpcouriersplease-shipping-nonce' ) ) {
		die( 'Security check Failed' );
	}
	
	// HANDLE EXPORT :: FORM POST
	if (isset($_POST['btnSubmit'])) 
	{
		
		$st = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));
		
		$accesstoken="";

		$shop_id="";
		
		if (is_array($st) && count($st) ) 
		{
			if( isset($st['accesstoken']) && ''!=$st['accesstoken'] ) 
			{
				$accesstoken = $st['accesstoken'];
			}
			if( isset($st['shop_id']) && ''!=$st['shop_id'] ) 
			{
				$shop_id = $st['shop_id'];
			}
		}
		
		
		if( $accesstoken !=""  && $shop_id !="" )
		{
			// Proceed
			$countries = [
				 'CA' => 'Canada',
				 'AU' => 'Australia',
				 'US' => 'United States',
				 'NZ' => 'New Zealand'
			];	
			
			// FIND 2 months OLD date
			$lastdate = date("Y-m-d", strtotime("-240 days"));
			
			// STEP 1.1 :: GET UNITs
			$wt_unit = get_option('woocommerce_weight_unit');
			$dm_unit = get_option('woocommerce_dimension_unit');

			// check if HPOS is enabled
			$hpos_enabled = 0;

			if (class_exists(\Automattic\WooCommerce\Utilities\OrderUtil::class) ) {
				if (\Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled() ) {
					$hpos_enabled  = 1;
				}
			}

			// MAIN ARRAY
			$orderlist = [];
			
			// HPOS is NOT enabled
			if (0 == $hpos_enabled) {
				
				// STEP 2 :: GET ALL Orders from WooCommerce
				global $wpdb, $table_prefix;
				$table_name = $wpdb->prefix . 'posts';

				$results = $wpdb->get_results(
					$wpdb->prepare(
					"SELECT ID, post_date, post_date_gmt, post_excerpt, post_title, post_status, post_name FROM %1s WHERE post_type = %s " . 
					" and post_date >='%s' order by post_date DESC limit 0, 1000", $table_name, 'shop_order', $lastdate
					)
				);

				$j = 0;
				
				// STEP 3 :: Loop Through
				for ($i=0; $i<count($results); $i++) {
					
					$order_id = $results[$i]->ID;
					
					$order_comment = $results[$i]->post_excerpt; // CUstomer NOte on Order
					
					$metadata = $wpdb->get_results(
						$wpdb->prepare('SELECT * FROM ' . $wpdb->prefix . 'postmeta WHERE post_id=%d', $order_id )
					);

					$arr = [];
					$is_couriersplease_order = 0;

					foreach ($metadata as $single) {
						// KEYs to overlook
						// if( in_array($single->meta_key,['couriersplease_post_error']) ) continue;
						$newkey = $single->meta_key;
						if( $newkey !== null )
						{
							if (strpos($newkey, '_') == 0) 
							{
								$newkey = substr($newkey, 1);
							}
							$arr[$newkey]=$single->meta_value;
						}
					}

					// MERGE ORDER (POST Object) and POST_META
					$temp = (array) $results[$i];
					$temp['created_at'] = $results[$i]->post_date_gmt;
					$orderlist[$j] = array_merge($temp, $arr);

					// LOad Order Object
					$wcorder = wc_get_order($results[$i]->ID);
					$wcuser  = $wcorder->get_user();
					
					// NEW ADDED LINES
					$get_billing_company = method_exists($wcorder,'get_billing_company')? $wcorder->get_billing_company() : '';
					$get_billing_email   = method_exists($wcorder,'get_billing_email')? $wcorder->get_billing_email() : '';
					$get_billing_phone   = method_exists($wcorder,'get_billing_phone')? $wcorder->get_billing_phone() : '';
					$get_total = method_exists($wcorder, 'get_total')? $wcorder->get_total() : '0.00';
					$get_discount_total = method_exists($wcorder,'get_discount_total')? $wcorder->get_discount_total() : '0.00';
					$get_total_tax = method_exists($wcorder,'get_total_tax') ? $wcorder->get_total_tax() : '0.00';
					$get_shipping_total = method_exists($wcorder,'get_shipping_total') ? $wcorder->get_shipping_total() : '0.00';
					$get_status = $wcorder->get_status() != '' ? $wcorder->get_status() : $results[$i]->post_status ;
					$currency = method_exists($wcorder,'get_currency') ? $wcorder->get_currency() : 'AUD';
				
					$allopt = $st;
					$orderlist[$j]['sender_name'] = isset($allopt['sender_name']) ? $allopt['sender_name'] : '';
					$orderlist[$j]['sender_contact_number'] = isset($allopt['sender_contact_number']) ? $allopt['sender_contact_number'] : '';
					$orderlist[$j]['sender_address'] = isset($allopt['sender_address']) ? $allopt['sender_address'] : '';
					$orderlist[$j]['sender_state'] = isset($allopt['sender_state']) ? $allopt['sender_state'] : '';
					$orderlist[$j]['sender_instruction'] = isset($allopt['sender_instruction']) ? $allopt['sender_instruction'] : '';
					$orderlist[$j]['receiver_instruction'] = isset($allopt['receiver_instruction']) ? $allopt['receiver_instruction'] : '';
					$orderlist[$j]['id'] = $results[$i]->ID;
					$orderlist[$j]['admin_graphql_api_id'] = '';
					$orderlist[$j]['app_id'] = '';
					$orderlist[$j]['browser_ip'] = isset($_SERVER['REMOTE_ADDR'])&& ''!=$_SERVER['REMOTE_ADDR']?esc_url_raw($_SERVER['REMOTE_ADDR']):'';
					$orderlist[$j]['buyer_accepts_marketing'] = '';
					$orderlist[$j]['cancel_reason'] = '';
					$orderlist[$j]['cart_token'] = '';
					$orderlist[$j]['checkout_id'] = '';
					$orderlist[$j]['checkout_token'] = '';
					$orderlist[$j]['client_details'] =
					[ 'accept_language' => get_locale(),
						  'browser_height'  => '',
						  'browser_ip' => isset($_SERVER['REMOTE_ADDR'])&& ''!=$_SERVER['REMOTE_ADDR']?esc_url_raw($_SERVER['REMOTE_ADDR']):'',
						  'browser_width' => '',
						  'session_hash' => '',
						  'user_agent' => ''
					];
					$orderlist[$j]['cancelled_at']='';
					$orderlist[$j]['closed_at']='';
					$orderlist[$j]['company'] = $get_billing_company !='' ? $get_billing_company : $orderlist[$j]['sender_name'];
					$orderlist[$j]['confirmation_number']='';
					$orderlist[$j]['confirmed']='';
					$orderlist[$j]['contact_email'] = $get_billing_email;
					$orderlist[$j]['currency'] = $currency;
					$orderlist[$j]['current_subtotal_price'] = $get_total;
					$orderlist[$j]['current_total_additional_fees_set'] = '';
					$orderlist[$j]['current_total_discounts'] = $get_discount_total;
					$orderlist[$j]['current_total_duties_set'] = '0.00';
					$orderlist[$j]['current_total_price'] = $get_total;
					$orderlist[$j]['current_total_tax'] = $get_total_tax;
					$orderlist[$j]['customer_locale'] = get_locale();
					$orderlist[$j]['device_id']='';
					$orderlist[$j]['email'] = $get_billing_email;
					$orderlist[$j]['estimated_taxes'] = $get_total_tax;
					$orderlist[$j]['financial_status']   = '';
					$orderlist[$j]['fulfillment_status'] = '';
					$orderlist[$j]['landing_site'] = '/';
					$orderlist[$j]['landing_site_ref'] = '';
					$orderlist[$j]['location_id'] = '';
					$orderlist[$j]['merchant_of_record_app_id'] = '';
					$orderlist[$j]['name'] = '#' . $results[$i]->ID; // Order Name
					$orderlist[$j]['note'] = $order_comment;
					$orderlist[$j]['note_attributes'] = [];
					$orderlist[$j]['number'] = $results[$i]->ID;
					$orderlist[$j]['order_number'] = $results[$i]->ID;
					$orderlist[$j]['order_status_url']='';
					$orderlist[$j]['original_total_additional_fees_set']='';
					$orderlist[$j]['original_total_duties_set']='';
					$orderlist[$j]['phone'] = $get_billing_phone;
					$orderlist[$j]['po_number']='';
					$orderlist[$j]['presentment_currency'] = $currency;
					$orderlist[$j]['processed_at'] = $results[$i]->post_date_gmt;
					$orderlist[$j]['reference'] = '';
					$orderlist[$j]['referring_site'] = '';
					$orderlist[$j]['source_identifier'] = '';
					$orderlist[$j]['source_name']='web';
					$orderlist[$j]['source_url']='';
					$orderlist[$j]['subtotal_price'] = $get_total;
					$orderlist[$j]['tags'] = '';
					$orderlist[$j]['tax_exempt']='';
					$orderlist[$j]['taxes_included']='';
					$orderlist[$j]['test']='';
					$orderlist[$j]['token']='';
					$orderlist[$j]['total_discounts'] = $get_discount_total;
					$orderlist[$j]['total_line_items_price'] = '';
					$orderlist[$j]['total_outstanding']='0.00';
					$orderlist[$j]['total_price'] = $get_total;
					$orderlist[$j]['total_tax'] = $get_total_tax;
					$orderlist[$j]['total_tip_received'] = '000';
					$orderlist[$j]['total_weight'] = '0';
					$orderlist[$j]['updated_at'] = $results[$i]->post_date_gmt;
					$orderlist[$j]['user_id'] = '';
					$orderlist[$j]['payment_terms'] = '';

					$orderlist[$j]['woocom_status'] = $get_status != '' ? $get_status : $results[$i]->post_status;

					$orderlist[$j]['total_price_set'] = [
					'shop_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['total_shipping_price_set'] = [
					'shop_money' => [ 'amount' => $get_shipping_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_shipping_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['subtotal_price_set'] = [
					'shop_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['current_total_tax_set'] = [
					'shop_money' => [ 'amount' => $get_total_tax, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_total_tax, 'currency_code' => $currency ],
					];

					$orderlist[$j]['current_subtotal_price_set'] = [
					'shop_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['current_total_price_set'] = [
					'shop_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['current_total_discounts_set'] = [
					'shop_money' => [ 'amount' => $get_discount_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_discount_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['tax_lines'] = [];
					$orderlist[$j]['tax_lines'][0] = [
					'price' => $get_total_tax,
					'rate' => 0.001,
					'title' => 'TAX',
					'price_set' =>
					[
								'shop_money' =>
								[
										'amount' => $get_total_tax,
										'currency_code' => $currency
								],

								'presentment_money' =>
								[
										'amount' => $get_total_tax,
										'currency_code' => $currency
								]

					],
					'channel_liable' => ''
					];

					//unset( $orderlist[$j]['ID'] );


					$orderlist[$j]['billing_address'] =
					[
						'first_name' => $orderlist[$j]['billing_first_name'],
						'last_name' => $orderlist[$j]['billing_last_name'],
						'address1' => $orderlist[$j]['billing_address_1'],
						'address2' => isset($orderlist[$j]['billing_address_2']) ? $orderlist[$j]['billing_address_2'] : '',
						'phone' => isset($orderlist[$j]['billing_phone']) ? $orderlist[$j]['billing_phone'] : '',
						'city' => $orderlist[$j]['billing_city'],
						'province' => $orderlist[$j]['billing_state'],
						'country' => $countries[$orderlist[$j]['billing_country']],
						'country_code' => $orderlist[$j]['billing_country'],
						'province_code' => $orderlist[$j]['billing_state'],
						'zip' => $orderlist[$j]['billing_postcode'],
						'company' => isset($orderlist[$j]['billing_company']) ? $orderlist[$j]['billing_company'] : '',
						'latitude' => '',
						'longitude' => '',
						'name' => $orderlist[$j]['billing_first_name'] . ' ' . $orderlist[$j]['billing_last_name']
					];

					$orderlist[$j]['shipping_address'] = [
					'first_name' => $orderlist[$j]['shipping_first_name'],
					'last_name' => $orderlist[$j]['shipping_last_name'],
					'address1' => $orderlist[$j]['shipping_address_1'],
					'address2' => isset($orderlist[$j]['shipping_address_2']) ? $orderlist[$j]['shipping_address_2'] : '',
					'phone' => isset($orderlist[$j]['shipping_phone']) ? $orderlist[$j]['shipping_phone'] : '',
					'city' => $orderlist[$j]['shipping_city'],
					'province' => $orderlist[$j]['shipping_state'],
					'country' => $countries[$orderlist[$j]['shipping_country']],
					'country_code' => $orderlist[$j]['shipping_country'],
					'province_code' => $orderlist[$j]['shipping_state'],
					'zip' => $orderlist[$j]['shipping_postcode'],
					'company' => isset($orderlist[$j]['shipping_company']) ? $orderlist[$j]['shipping_company'] : '',
					'latitude' => '',
					'longitude' => '',
					'name' => $orderlist[$j]['shipping_first_name'] . ' ' . $orderlist[$j]['shipping_last_name']
					];

					if ($wcuser) {

						$orderlist[$j]['customer'] =
						[
						'id' => $wcuser->id,
						'email' => $wcuser->user_email,
						'accepts_marketing' => '',
						'created_at' => $wcuser->user_registered,
						'updated_at' => $wcuser->user_registered,
						'first_name' => get_user_meta($wcuser->id, 'first_name', true),
						'last_name'  => get_user_meta($wcuser->id, 'last_name', true),
						'state'      => get_user_meta($wcuser->id, 'billing_state', true),
						'note' => '',
						'verified_email' => '',
						'multipass_identifier' => '',
						'tax_exempt' => '',
						'phone' => get_user_meta($wcuser->id, 'billing_phone', true),
						'email_marketing_consent' =>
						[
						'state' => '',
						'opt_in_level' => '',
						'consent_updated_at' => ''
						],

						'sms_marketing_consent' => '',
						'tags' => '',
						'currency' => $currency,
						'accepts_marketing_updated_at' => '',
						'marketing_opt_in_level' => '',
						'tax_exemptions' => [],
						'admin_graphql_api_id' => '',
						'default_address' =>
						[
									'id' => '1',
									'customer_id' => $wcuser->id,
									'first_name' => get_user_meta($wcuser->id, 'first_name', true),
									'last_name'  => get_user_meta($wcuser->id, 'last_name', true),
									'company' => get_user_meta($wcuser->id, 'billing_company', true),
									'address1' => get_user_meta($wcuser->id, 'billing_address_1', true),
									'address2' => get_user_meta($wcuser->id, 'billing_address_2', true),
									'city' => get_user_meta($wcuser->id, 'billing_city', true),
									'province' => get_user_meta($wcuser->id, 'billing_state', true),
									'country' => $countries[get_user_meta($wcuser->id, 'billing_country', true)],
									'zip' => get_user_meta($wcuser->id, 'billing_postcode', true),
									'phone' => get_user_meta($wcuser->id, 'billing_phone', true),
									'name' => trim(get_user_meta($wcuser->id, 'first_name', true) . ' ' . get_user_meta($wcuser->id, 'last_name', true)),
									'province_code' => get_user_meta($wcuser->id, 'billing_state', true),
									'country_code' => get_user_meta($wcuser->id, 'billing_country', true),
									'country_name' => $countries[get_user_meta($wcuser->id, 'billing_country', true)],
									'default' => 1
						]

						];
					} else {
						$orderlist[$j]['customer'] =
						[
						'id'     =>  $orderlist[$j]['customer_user'],
						'email'  =>  $orderlist[$j]['billing_email'],
						'accepts_marketing' => '',
						'created_at' => $orderlist[$j]['created_at'],
						'updated_at' => $orderlist[$j]['created_at'],
						'first_name' => $orderlist[$j]['billing_first_name'],
						'last_name'  => $orderlist[$j]['billing_last_name'],
						'state'      => $orderlist[$j]['billing_state'],
						'note'       => '',
						'verified_email' => '',
						'multipass_identifier' => '',
						'tax_exempt' => '',
						'phone'      => isset($orderlist[$j]['billing_phone']) ? $orderlist[$j]['billing_phone'] : '',
						'email_marketing_consent' =>
						[
						'state' => '',
						'opt_in_level' => '',
						'consent_updated_at' => ''
						],

						'sms_marketing_consent' => '',
						'tags'       => '',
						'currency'   => $orderlist[$j]['order_currency'],
						'accepts_marketing_updated_at' => '',
						'marketing_opt_in_level'       => '',
						'tax_exemptions'               => [],
						'admin_graphql_api_id'         => '',
						'default_address' =>
						[
							'id' => '1',
							'customer_id' => '0',
							'first_name'  => $orderlist[$j]['billing_first_name'],
							'last_name'   => $orderlist[$j]['billing_last_name'],
							'company'     => '',
							'address1'    => $orderlist[$j]['billing_address_1'],
							'address2'    => '',
							'city'        => $orderlist[$j]['billing_city'],
							'province'    => $orderlist[$j]['billing_state'],
							'country'     => $countries[ $orderlist[$j]['billing_country'] ],
							'zip'         => $orderlist[$j]['billing_postcode'],
							'phone'       => isset($orderlist[$j]['billing_phone']) ? $orderlist[$j]['billing_phone'] : '',
							'name'        => trim($orderlist[$j]['billing_first_name'] . ' ' . $orderlist[$j]['billing_last_name']),
							'province_code' => $orderlist[$j]['billing_state'],
							'country_code'  => $orderlist[$j]['billing_country'],
							'country_name'  => $countries[ $orderlist[$j]['billing_country'] ],
							'default'     => 1
						]

						];
					}

					// Fulfilments
					$fulfil = get_post_meta($order_id, 'joovii_couriersplease_order_id', true);

					if (!empty($fulfil) ) {
						$orderlist[$j]['fulfillments'] =
						[
							[
							'provider' => 'jooviicouriersplease',
							'product'  => 'standard',
							'postjson' => get_post_meta($order_id, 'joovii_couriersplease_post', true),
							'responsejson' => get_post_meta($order_id, 'joovii_couriersplease_response', true),
							'couriersplease_order_id' =>  $fulfil,
							'couriersplease_reference' => get_post_meta($order_id, 'joovii_couriersplease_reference', true),
							'couriersplease_tracking_url' => get_post_meta($order_id, 'joovii_couriersplease_tracking_url', true),
							'error' => '0'
							]
						];
					}


					/// GET ORDER ITEMS
					$wcorder = new WC_Order($order_id);
					$items = $wcorder->get_items();
					$line_items_arr = [];
					
					if( is_array($items) )
					{
						foreach ($items as $item_id => $item) {
							// GET PRODUCT
							$product = $item->get_product();
							
							if(!$product) continue;
							
							$product_id = $product->get_id();

							$imageArr = '';
							$imageArr = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'single-post-thumbnail');
							$product_image = '';
							if (is_array($imageArr) && count($imageArr) ) {
								$product_image = $imageArr[0];
							}

							// calculate product weight
							$prod_wt = $product->get_weight();
							$grams = 0;
							if ('' != $prod_wt && '' != $wt_unit) {
								if ('g' == $wt_unit) {
									$grams = $prod_wt;
								}
								if ('kg' == $wt_unit) {
									$grams = $prod_wt * 1000;
								}
								if ('lbs' == $wt_unit) {
									$grams = number_format($prod_wt * 453.592, 2);
								}
								if ('oz' == $wt_unit) {
									$grams = number_format($prod_wt * 28.3495, 2);
								}
							}

							// Calculate Dimensions
							$prod_ln = $product->get_length();
							$prod_ht = $product->get_height();
							$prod_wd = $product->get_width();

							$dm_ln = 0;
							$dm_ht = 0;
							$dm_wd = 0;

							$dimentions_array = [];

							if ('' != $dm_unit) {
								if ('cm' == $dm_unit) {
									$dm_ln = ( '' != $prod_ln ? $prod_ln : 0 );
									$dm_ht = ( '' != $prod_ht ? $prod_ht : 0 );
									$dm_wd = ( '' != $prod_wd ? $prod_wd : 0 );
								}

								if ('mm' == $dm_unit) {
									$dm_ln = ( '' != $prod_ln ? $prod_ln / 10 : 0 );
									$dm_ht = ( '' != $prod_ht ? $prod_ht / 10 : 0 );
									$dm_wd = ( '' != $prod_wd ? $prod_wd / 10 : 0 );
								}

								if ('in' == $dm_unit) {
									$dm_ln = ( '' != $prod_ln ? $prod_ln * 2.54 : 0 );
									$dm_ht = ( '' != $prod_ht ? $prod_ht * 2.54 : 0 );
									$dm_wd = ( '' != $prod_wd ? $prod_wd * 2.54 : 0 );
								}

								if ('yd' == $dm_unit) {
									$dm_ln = ( '' != $prod_ln ? $prod_ln * 91.44 : 0 );
									$dm_ht = ( '' != $prod_ht ? $prod_ht * 91.44 : 0 );
									$dm_wd = ( '' != $prod_wd ? $prod_wd * 91.44 : 0 );
								}

								$dimentions_array = ['l' => $dm_ln, 'h' => $dm_ht, 'w' => $dm_wd];
							}

							$total_price_array = [ 'amount' => $item->get_total(), 'currency_code' => $currency ];
							$total_discount_array = [ 'amount' => '0.00', 'currency_code' => $currency ];
							$total_tax_array = [ 'amount' => $item->get_subtotal_tax(), 'currency_code' => $currency ];

							$line_items_arr[] =
							[
							'id' => $product_id,
							'admin_graphql_api_id' => '',
							'fulfillable_quantity' => 0,
							'fulfillment_service'  => '',
							'fulfillment_status'   => '',
							'gift_card' => '',
							'grams' => $grams,
							'image' => $product_image,
							'dimension' => $dimentions_array,
							'name'  => $item->get_name(),
							'price' => $item->get_total(),
							'price_set' => ['shop_money' => $total_price_array, 'presentment_money' => $total_price_array],
							'product_exists' => 1,
							'product_id' => $product_id,
							'properties' => [],
							'quantity'   => $item->get_quantity(),
							'requires_shipping' => 1,
							'sku' => $product->get_sku(),
							'taxable' => 0,
							'title' => $item->get_name(),
							'total_discount' => '',
							'total_discount_set' => ['shop_money' => $total_discount_array,    'presentment_money' => $total_discount_array],
							'variant_id' => ( $item->get_variation_id() > '0' ? $item->get_variation_id() : $product_id ),
							'variant_inventory_management' => 'woocom',
							'variant_title' => $item->get_name(),
							'vendor' => '',
							'tax_lines' =>
								[
									[
										'rate'  => '0.1',
										'title' => 'TAX',
										'channel_liable' => '',
										'price' => $item->get_subtotal(),
										'price_set' => ['shop_money' => $total_tax_array, 'presentment_money' => $total_tax_array]
									]
								],

							'duties' => [],
							'discount_allocations' => []

							];

							$orderlist[$j]['items'][] = $item['name'];
						}
					}
					
					$orderlist[$j]['line_items'] = $line_items_arr;
					$j++;
					//break;
				}
			} else {
				
				
				$results = wc_get_orders(["limit" => 1000, 'orderby' => 'ID', 'order' => 'DESC', 'date_created' => ">=$lastdate"]);
				
				$j = 0;
				
				
				// STEP 3 :: Loop Through
				for ($i=0; $i<count($results); $i++) 
				{

					$order_id = $results[$i]->get_id();
		
					$table_name = $wpdb->prefix . 'wc_orders_meta';

					$metadata = $wpdb->get_results(
						$wpdb->prepare('SELECT * FROM ' . $table_name . ' WHERE order_id = %d', $order_id)
					);

					$arr = [];
					$is_couriersplease_order = 0;

					foreach ($metadata as $single) {
						// KEYs to overlook
						// if( in_array($single->meta_key,['couriersplease_post_error']) ) continue;
						$newkey = $single->meta_key;
						if( $newkey !== null )
						{
							if (strpos($newkey, '_') == 0) {
								  $newkey = substr($newkey, 1);
							}
							
							$arr[$newkey] = $single->meta_value;
						}
					}
				
					// MERGE ORDER (ORDER Object) and ORDER_META
					$temp = (array) $results[$i]->get_data();

					$dateObject = (array) $temp['date_created'];
				
					$temp['created_at'] = $dateObject['date'];

					$orderlist[$j] = array_merge($temp, $arr);
					
					// LOAD other related TABLES
					$billing_details = $wpdb->get_results(
						$wpdb->prepare(
						'SELECT * FROM ' . $wpdb->prefix . 'wc_order_addresses WHERE order_id=%d and address_type=%s',
						$order_id, 'billing'
						)
					);

					$shipping_details = $wpdb->get_results(
						$wpdb->prepare(
						'SELECT * FROM ' . $wpdb->prefix . 'wc_order_addresses WHERE order_id=%d and address_type=%s',
						$order_id, 'shipping'
						)
					);

					$operatn_details = $wpdb->get_results(
						$wpdb->prepare(
						'SELECT * FROM ' . $wpdb->prefix . 'wc_order_operational_data WHERE order_id=%d',
						$order_id
						)
					);

					// LOAD Order Object
					$wcorder = wc_get_order( $order_id );

					$wcuser  = $wcorder->get_user();
					
					// NEW ADDED LINES
					$get_billing_company = method_exists($wcorder,'get_billing_company')? $wcorder->get_billing_company() : '';
					$get_billing_email   = method_exists($wcorder,'get_billing_email')? $wcorder->get_billing_email() : '';
					$get_billing_phone   = method_exists($wcorder,'get_billing_phone')? $wcorder->get_billing_phone() : '';
					$get_total = method_exists($wcorder, 'get_total')? $wcorder->get_total() : '0.00';
					$get_discount_total = method_exists($wcorder,'get_discount_total')? $wcorder->get_discount_total() : '0.00';
					$get_total_tax = method_exists($wcorder,'get_total_tax') ? $wcorder->get_total_tax() : '0.00';
					$get_shipping_total = method_exists($wcorder,'get_shipping_total') ? $wcorder->get_shipping_total() : '0.00';
					$get_status = $wcorder->get_status() != '' ? $wcorder->get_status() : $results[$i]->post_status ;
					$currency = method_exists($wcorder,'get_currency') ? $wcorder->get_currency() : 'AUD';
					$get_payment_method = method_exists($wcorder,'get_payment_method') ?  $wcorder->get_payment_method() : '';
					$get_payment_method_title = method_exists($wcorder,'get_payment_method_title') ?  $wcorder->get_payment_method_title() : '';
					$get_customer_note = method_exists($wcorder, 'get_customer_note') ? $wcorder->get_customer_note() : '';
					
					
					$allopt = $st;
					$orderlist[$j]['sender_name'] = isset($allopt['sender_name']) ? $allopt['sender_name'] : $get_billing_company;
					$orderlist[$j]['sender_contact_number'] = isset($allopt['sender_contact_number']) ? $allopt['sender_contact_number'] : $get_billing_phone;
					$orderlist[$j]['sender_address'] = isset($allopt['sender_address']) ? $allopt['sender_address'] : '';
					$orderlist[$j]['sender_state'] = isset($allopt['sender_state']) ? $allopt['sender_state'] : '';
					$orderlist[$j]['sender_instruction'] = isset($allopt['sender_instruction']) ? $allopt['sender_instruction'] : '';
					$orderlist[$j]['receiver_instruction'] = isset($allopt['receiver_instruction']) ? $allopt['receiver_instruction'] : '';
					$orderlist[$j]['ID'] = $order_id;

					// BUILD Order OBJECT -- New Addition
					$orderlist[$j]['post_date'] = $dateObject['date'];
					$orderlist[$j]['post_date_gmt'] = $dateObject['date'];
					$orderlist[$j]['post_title'] = 'Order #' . $order_id;
					
					$orderlist[$j]['post_status'] = $get_status;
					$orderlist[$j]['woocom_status'] = $get_status;
		
					$orderlist[$j]['post_name'] = 'Order #' . $order_id;
					$orderlist[$j]['created_at'] = $dateObject['date'];

					$orderlist[$j]['cart_discount'] = '';
					$orderlist[$j]['cart_discount_tax'] = '';

					$orderlist[$j]['order_shipping'] = isset($operatn_details[0]->shipping_total_amount) ? $operatn_details[0]->shipping_total_amount : '';
					$orderlist[$j]['order_shipping_tax'] = isset($operatn_details[0]->shipping_tax_amount) ? $operatn_details[0]->shipping_tax_amount : '';

					$orderlist[$j]['order_tax']   = $get_total_tax;
					$orderlist[$j]['order_total'] = $get_total;

					$orderlist[$j]['order_version'] = isset($operatn_details[0]->woocommerce_version) ? $operatn_details[0]->woocommerce_version : '';
					$orderlist[$j]['order_key'] = isset($operatn_details[0]->order_key) ? $operatn_details[0]->order_key : '';

					$orderlist[$j]['customer_user'] = (array)$wcuser;

					$orderlist[$j]['payment_method'] = $get_payment_method;
					$orderlist[$j]['payment_method_title'] = $get_payment_method_title;

					$orderlist[$j]['prices_include_tax'] = '';
					$orderlist[$j]['order_currency'] = $currency;

					$sa = '';

					if (isset($shipping_details[0])) {
						$sa = (array) $shipping_details[0];
					}

					if ( isset($orderlist[$j]['shipping_address_index']) && '' == $orderlist[$j]['shipping_address_index']) {
						$addr = ( isset($sa['address_1']) ? $sa['address_1'] : '' ) .
						 ( isset($sa['address_2']) && '' != $sa['address_2'] ? ', ' . $sa['address_2'] :'' ) .
						 ( isset($sa['city']) && '' != $sa['city'] ? ', ' . $sa['city'] : '' ) .
						 ( isset($sa['state']) && '' != $sa['state'] ? ', ' . $sa['state'] : '' ) .
						 ( isset($sa['postcode']) && '' != $sa['postcode'] ? ', ' . $sa['postcode'] : '' ) .
						 ( isset($sa['country']) && '' != $sa['country'] ? ', ' . $sa['country'] : '' );

						$orderlist[$j]['shipping_address_index'] = $addr;
					}

					$orderlist[$j]['shipping_address_1'] = ( isset($sa['address_1']) && '' != $sa['address_1'] ? $sa['address_1'] :'' );
					$orderlist[$j]['shipping_address_2'] = ( isset($sa['address_2']) && '' != $sa['address_2'] ? $sa['address_2'] :'' );
					$orderlist[$j]['shipping_city'] = ( isset($sa['city']) && '' != $sa['city'] ? $sa['city'] :'' );
					$orderlist[$j]['shipping_state'] = ( isset($sa['state']) && '' != $sa['state'] ? $sa['state'] :'' );
					$orderlist[$j]['shipping_postcode'] = ( isset($sa['postcode']) && '' != $sa['postcode'] ? $sa['postcode'] :'' );
					$orderlist[$j]['shipping_country'] = ( isset($sa['country']) && '' != $sa['country'] ? $sa['country'] :'' );

					$orderlist[$j]['shipping_first_name'] = ( isset($sa['first_name']) && '' != $sa['first_name'] ? $sa['first_name'] :'' );
					$orderlist[$j]['shipping_last_name'] = ( isset($sa['last_name']) && '' != $sa['last_name'] ? $sa['last_name'] :'' );
					$orderlist[$j]['shipping_company'] = ( isset($sa['company']) && '' != $sa['company'] ? $sa['company'] :'' );
					$orderlist[$j]['shipping_email'] = ( isset($sa['email']) && '' != $sa['email'] ? $sa['email'] :'' );
					$orderlist[$j]['shipping_phone'] = ( isset($sa['phone']) && '' != $sa['phone'] ? $sa['phone'] :'' );
					$ba = '';

					if (isset($billing_details[0])) {
						$ba = (array) $billing_details[0];
					}

					if (isset($orderlist[$j]['billing_address_index']) && '' == $orderlist[$j]['billing_address_index']) {
						$addr = ( isset($ba['address_1']) && ''!=$ba['address_1']? $ba['address_1'] :'' ) .
						 ( isset($ba['address_2']) && ''!=$ba['address_2']? ', ' . $ba['address_2'] :'' ) .
						 ( isset($ba['city']) && ''!=$ba['city'] ? ', ' . $ba['city'] :'' ) .
						 ( isset($ba['state']) && ''!=$ba['state'] ? ', ' . $ba['state'] :'' ) .
						 ( isset($ba['postcode']) && ''!=$ba['postcode'] ? ', ' . $ba['postcode'] :'' ) .
						 ( isset($ba['country']) && ''!=$ba['country'] ? ', ' . $ba['country'] :'' );
						$orderlist[$j]['billing_address_index'] = $addr;
					}

					$orderlist[$j]['billing_email'] = ( isset($ba['email']) && ''!=$ba['email'] ? $ba['email'] :'' );
					$orderlist[$j]['billing_company'] = ( isset($ba['company']) && ''!=$ba['company'] ? $ba['company'] :'' );
					$orderlist[$j]['billing_first_name'] = ( isset($ba['first_name']) && ''!=$ba['first_name'] ? $ba['first_name'] :'' );
					$orderlist[$j]['billing_last_name'] = ( isset($ba['last_name']) && ''!=$ba['last_name'] ? $ba['last_name'] :'' );
					$orderlist[$j]['billing_phone'] = ( isset($ba['phone']) && ''!=$ba['phone'] ? $ba['phone'] :'' );

					$orderlist[$j]['billing_address_1'] = ( isset($ba['address_1']) && ''!=$ba['address_1'] ? $ba['address_1'] :'' );
					$orderlist[$j]['billing_address_2'] = ( isset($ba['address_2']) && ''!=$ba['address_2'] ? $ba['address_2'] :'' );
					$orderlist[$j]['billing_city'] = ( isset($ba['city']) && ''!=$ba['city'] ? $ba['city'] :'' );
					$orderlist[$j]['billing_state'] = ( isset($ba['state']) && ''!=$ba['state'] ? $ba['state'] :'' );
					$orderlist[$j]['billing_postcode'] = ( isset($ba['postcode']) && ''!=$ba['postcode'] ? $ba['postcode'] :'' );
					$orderlist[$j]['billing_country'] = ( isset($ba['country']) && ''!=$ba['country'] ? $ba['country'] :'' );

					$orderlist[$j]['order_stock_reduced'] = '';
					$orderlist[$j]['new_order_email_sent'] = '';
					///////////////////////////////////////////
	
					$orderlist[$j]['id'] = $order_id;
					$orderlist[$j]['admin_graphql_api_id'] = '';
					$orderlist[$j]['app_id'] = '';
					$orderlist[$j]['browser_ip'] = isset($_SERVER['REMOTE_ADDR']) && ''!=$_SERVER['REMOTE_ADDR']?esc_url_raw($_SERVER['REMOTE_ADDR']):'';
					$orderlist[$j]['buyer_accepts_marketing'] = '';
					$orderlist[$j]['cancel_reason'] = '';
					$orderlist[$j]['cart_token'] = '';
					$orderlist[$j]['checkout_id'] = '';
					$orderlist[$j]['checkout_token'] = '';
					$orderlist[$j]['client_details'] =
					[ 'accept_language' => get_locale(),
						  'browser_height'  => '',
						  'browser_ip' => isset($_SERVER['REMOTE_ADDR']) && ''!=$_SERVER['REMOTE_ADDR']?esc_url_raw($_SERVER['REMOTE_ADDR']):'',
						  'browser_width' => '',
						  'session_hash' => '',
						  'user_agent' => ''
					];
					$orderlist[$j]['cancelled_at']='';
					$orderlist[$j]['closed_at']='';
					$orderlist[$j]['company'] = $get_billing_company;
					$orderlist[$j]['confirmation_number']='';
					$orderlist[$j]['confirmed']='';
					$orderlist[$j]['contact_email'] = $get_billing_email;
					$orderlist[$j]['currency'] = $currency;
					$orderlist[$j]['current_subtotal_price'] = $get_total;
					$orderlist[$j]['current_total_additional_fees_set'] = '';
					$orderlist[$j]['current_total_discounts'] = $get_discount_total;
					$orderlist[$j]['current_total_duties_set'] = '0.00';
					$orderlist[$j]['current_total_price'] = $get_total;
					$orderlist[$j]['current_total_tax'] = $get_total_tax;
					$orderlist[$j]['customer_locale'] = get_locale();
					$orderlist[$j]['device_id']='';
					$orderlist[$j]['email'] = $get_billing_email;
					$orderlist[$j]['estimated_taxes']=$get_total_tax;
					$orderlist[$j]['financial_status']   = '';
					$orderlist[$j]['fulfillment_status'] = '';
					$orderlist[$j]['landing_site'] = '/';
					$orderlist[$j]['landing_site_ref'] = '';
					$orderlist[$j]['location_id'] = '';
					$orderlist[$j]['merchant_of_record_app_id'] = '';
					$orderlist[$j]['name'] = '#' . $order_id; // Order Name
					$orderlist[$j]['note'] = $get_customer_note;
					$orderlist[$j]['note_attributes'] = [];
					$orderlist[$j]['number'] = $order_id;
					$orderlist[$j]['order_number'] = $order_id;
					
					$orderlist[$j]['order_status_url']='';
					$orderlist[$j]['original_total_additional_fees_set']='';
					$orderlist[$j]['original_total_duties_set']='';
					$orderlist[$j]['phone'] = $get_billing_phone;
					$orderlist[$j]['po_number']='';
					$orderlist[$j]['presentment_currency'] = $currency;
					$orderlist[$j]['processed_at'] = $dateObject['date'];
					$orderlist[$j]['reference'] = '';
					$orderlist[$j]['referring_site'] = '';
					$orderlist[$j]['source_identifier'] = '';
					$orderlist[$j]['source_name']='web';
					$orderlist[$j]['source_url']='';
					$orderlist[$j]['subtotal_price'] = $get_total;
					$orderlist[$j]['tags'] = '';
					$orderlist[$j]['tax_exempt']='';
					$orderlist[$j]['taxes_included']='';
					$orderlist[$j]['test']='';
					$orderlist[$j]['token']='';
					$orderlist[$j]['total_discounts'] = $get_discount_total;
					$orderlist[$j]['total_line_items_price'] = '';
					
					$orderlist[$j]['total_outstanding']='0.00';
					$orderlist[$j]['total_price'] = $get_total;
					$orderlist[$j]['total_tax'] = $get_total_tax;
					$orderlist[$j]['total_tip_received'] = '000';
					$orderlist[$j]['total_weight'] = '0';
					$orderlist[$j]['updated_at'] = $dateObject['date'];
					$orderlist[$j]['user_id'] = '';
					$orderlist[$j]['payment_terms'] = '';

					$orderlist[$j]['total_price_set'] = [
					'shop_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['total_shipping_price_set'] = [
					'shop_money' => [ 'amount' => $get_shipping_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_shipping_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['subtotal_price_set'] = [
					'shop_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['current_total_tax_set'] = [
					'shop_money' => [ 'amount' => $get_total_tax, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_total_tax, 'currency_code' => $currency ],
					];

					$orderlist[$j]['current_subtotal_price_set'] = [
					'shop_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['current_total_price_set'] = [
					'shop_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['current_total_discounts_set'] = [
					'shop_money' => [ 'amount' => $get_discount_total, 'currency_code' => $currency ],
					'presentment_money' => [ 'amount' => $get_discount_total, 'currency_code' => $currency ],
					];

					$orderlist[$j]['tax_lines'] = [];
					$orderlist[$j]['tax_lines'][0] = [
					'price' => $get_total_tax,
					'rate' => 0.001,
					'title' => 'TAX',
					'price_set' =>
					[
								'shop_money' =>
								[
										'amount' => $get_total_tax,
										'currency_code' => $currency
								],

								'presentment_money' =>
								[
										'amount' => $get_total_tax,
										'currency_code' => $currency
								]

					],
					'channel_liable' => ''
					];

					//unset( $orderlist[$j]['id'] );


					$orderlist[$j]['billing_address'] =
					[
						'first_name' => $orderlist[$j]['billing_first_name'],
						'last_name' => $orderlist[$j]['billing_last_name'],
						'address1' => $orderlist[$j]['billing_address_1'],
						'address2' => $orderlist[$j]['billing_address_2'],
						'phone' => $orderlist[$j]['billing_phone'],
						'city' => $orderlist[$j]['billing_city'],
						'province' => $orderlist[$j]['billing_state'],
						'country' => $countries[$orderlist[$j]['billing_country']],
						'country_code' => $orderlist[$j]['billing_country'],
						'province_code' => $orderlist[$j]['billing_state'],
						'zip' => $orderlist[$j]['billing_postcode'],
						'company' => $orderlist[$j]['billing_company'],
						'latitude' => '',
						'longitude' => '',
						'name' => $orderlist[$j]['billing_first_name'] . ' ' . $orderlist[$j]['billing_last_name']
					];

					$orderlist[$j]['shipping_address'] = [
						'first_name' => $orderlist[$j]['shipping_first_name'],
						'last_name' => $orderlist[$j]['shipping_last_name'],
						'address1' => $orderlist[$j]['shipping_address_1'],
						'address2' => $orderlist[$j]['shipping_address_2'],
						'phone' => $orderlist[$j]['shipping_phone'],
						'city' => $orderlist[$j]['shipping_city'],
						'province' => $orderlist[$j]['shipping_state'],
						'country' => $countries[$orderlist[$j]['shipping_country']],
						'country_code' => $orderlist[$j]['shipping_country'],
						'province_code' => $orderlist[$j]['shipping_state'],
						'zip' => $orderlist[$j]['shipping_postcode'],
						'company' => $orderlist[$j]['shipping_company'],
						'latitude' => '',
						'longitude' => '',
						'name' => $orderlist[$j]['shipping_first_name'] . ' ' . $orderlist[$j]['shipping_last_name']
					];
					
					if ($wcuser) {

						$orderlist[$j]['customer'] =
						[
							'id' => $wcuser->id,
							'email' => $wcuser->user_email,
							'accepts_marketing' => '',
							'created_at' => $wcuser->user_registered,
							'updated_at' => $wcuser->user_registered,
							'first_name' => get_user_meta($wcuser->id, 'first_name', true),
							'last_name'  => get_user_meta($wcuser->id, 'last_name', true),
							'state'      => get_user_meta($wcuser->id, 'billing_state', true),
							'note' => '',
							'verified_email' => '',
							'multipass_identifier' => '',
							'tax_exempt' => '',
							'phone' => get_user_meta($wcuser->id, 'billing_phone', true),
							'email_marketing_consent' =>
							[
								'state' => '',
								'opt_in_level' => '',
								'consent_updated_at' => ''
							],
							'sms_marketing_consent' => '',
							'tags' => '',
							'currency' => $currency,
							'accepts_marketing_updated_at' => '',
							'marketing_opt_in_level' => '',
							'tax_exemptions' => [],
							'admin_graphql_api_id' => '',
							'default_address' =>
							[
								'id' => '1',
								'customer_id' => $wcuser->id,
								'first_name' => get_user_meta($wcuser->id, 'first_name', true),
								'last_name'  => get_user_meta($wcuser->id, 'last_name', true),
								'company' => get_user_meta($wcuser->id, 'billing_company', true),
								'address1' => get_user_meta($wcuser->id, 'billing_address_1', true),
								'address2' => get_user_meta($wcuser->id, 'billing_address_2', true),
								'city' => get_user_meta($wcuser->id, 'billing_city', true),
								'province' => get_user_meta($wcuser->id, 'billing_state', true),
								'country' => $countries[get_user_meta($wcuser->id, 'billing_country', true)],
								'zip' => get_user_meta($wcuser->id, 'billing_postcode', true),
								'phone' => get_user_meta($wcuser->id, 'billing_phone', true),
								'name' => trim(get_user_meta($wcuser->id, 'first_name', true) . ' ' . get_user_meta($wcuser->id, 'last_name', true)),
								'province_code' => get_user_meta($wcuser->id, 'billing_state', true),
								'country_code' => get_user_meta($wcuser->id, 'billing_country', true),
								'country_name' => $countries[get_user_meta($wcuser->id, 'billing_country', true)],
								'default' => 1
							]

						];
					} else {
						$orderlist[$j]['customer'] =
						[
						'id'     =>  $orderlist[$j]['customer_user'],
						'email'  =>  $orderlist[$j]['billing_email'],
						'accepts_marketing' => '',
						'created_at' => $orderlist[$j]['created_at'],
						'updated_at' => $orderlist[$j]['created_at'],
						'first_name' => $orderlist[$j]['billing_first_name'],
						'last_name'  => $orderlist[$j]['billing_last_name'],
						'state'      => $orderlist[$j]['billing_state'],
						'note'       => '',
						'verified_email' => '',
						'multipass_identifier' => '',
						'tax_exempt' => '',
						'phone'      => $orderlist[$j]['billing_phone'],
						'email_marketing_consent' =>
						[
						'state' => '',
						'opt_in_level' => '',
						'consent_updated_at' => ''
						],

						'sms_marketing_consent' => '',
						'tags'       => '',
						'currency'   => $orderlist[$j]['order_currency'],
						'accepts_marketing_updated_at' => '',
						'marketing_opt_in_level'       => '',
						'tax_exemptions'               => [],
						'admin_graphql_api_id'         => '',
						'default_address' =>
						[
							'id' => '1',
							'customer_id' => '0',
							'first_name'  => $orderlist[$j]['billing_first_name'],
							'last_name'   => $orderlist[$j]['billing_last_name'],
							'company'     => '',
							'address1'    => $orderlist[$j]['billing_address_1'],
							'address2'    => '',
							'city'        => $orderlist[$j]['billing_city'],
							'province'    => $orderlist[$j]['billing_state'],
							'country'     => $countries[ $orderlist[$j]['billing_country'] ],
							'zip'         => $orderlist[$j]['billing_postcode'],
							'phone'       => $orderlist[$j]['billing_phone'],
							'name'        => trim($orderlist[$j]['billing_first_name'] . ' ' . $orderlist[$j]['billing_last_name']),
							'province_code' => $orderlist[$j]['billing_state'],
							'country_code'  => $orderlist[$j]['billing_country'],
							'country_name'  => $countries[ $orderlist[$j]['billing_country'] ],
							'default'     => 1
						]

						];
					}


					// Fulfilments
					$fulfil = get_post_meta($order_id, 'joovii_couriersplease_order_id', true);

					if (!empty($fulfil)) {
						$orderlist[$j]['fulfillments'] =
						[
						[
						'provider' => 'jooviicouriersplease',
						'product'  => 'standard',
						'postjson' => get_post_meta($order_id, 'joovii_couriersplease_post', true),
						'responsejson' => get_post_meta($order_id, 'joovii_couriersplease_response', true),
						'couriersplease_order_id' =>  $fulfil,
						'couriersplease_reference' => get_post_meta($order_id, 'joovii_couriersplease_reference', true),
						'couriersplease_tracking_url' => get_post_meta($order_id, 'joovii_couriersplease_tracking_url', true),
						'error' => '0'
						]
						];
					}


					/// GET ORDER ITEMS
					// $wcorder = new WC_Order($order_id);
					$items = $wcorder->get_items();
					$line_items_arr = [];
					foreach ($items as $item_id => $item) 
					{

						// GET PRODUCT
						$product = $item->get_product();
						
						if( !$product ) continue;
						
						$product_id = $product->get_id();

						$imageArr = '';
						$imageArr = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'single-post-thumbnail');
						$product_image = '';
						if (is_array($imageArr) && count($imageArr) ) {
							$product_image = $imageArr[0];
						}
						// calculate product weight
						$prod_wt = $product->get_weight();
						$grams = 0;
						if ('' != $prod_wt && '' != $wt_unit) {
							if ('g' == $wt_unit) {
								$grams = $prod_wt;
							}
							if ('kg' == $wt_unit) {
								$grams = $prod_wt * 1000;
							}
							if ('lbs' == $wt_unit) {
								$grams = number_format($prod_wt * 453.592, 2);
							}
							if ('oz' == $wt_unit) {
								$grams = number_format($prod_wt * 28.3495, 2);
							}
						}

						// Calculate Dimensions
						$prod_ln = $product->get_length();
						$prod_ht = $product->get_height();
						$prod_wd = $product->get_width();

						$dm_ln = 0;
						$dm_ht = 0;
						$dm_wd = 0;

						$dimentions_array = [];
						if ('' != $dm_unit) {
							if ('cm' == $dm_unit) {
								$dm_ln = ( '' != $prod_ln ? $prod_ln : 0 );
								$dm_ht = ( '' != $prod_ht ? $prod_ht : 0 );
								$dm_wd = ( '' != $prod_wd ? $prod_wd : 0 );
							}

							if ('mm' == $dm_unit) {
								$dm_ln = ( '' != $prod_ln ? $prod_ln / 10 : 0 );
								$dm_ht = ( '' != $prod_ht ? $prod_ht / 10 : 0 );
								$dm_wd = ( '' != $prod_wd ? $prod_wd / 10 : 0 );
							}

							if ('in' == $dm_unit) {
								$dm_ln = ( '' != $prod_ln ? $prod_ln * 2.54 : 0 );
								$dm_ht = ( '' != $prod_ht ? $prod_ht * 2.54 : 0 );
								$dm_wd = ( '' != $prod_wd ? $prod_wd * 2.54 : 0 );
							}

							if ('yd' == $dm_unit) {
								$dm_ln = ( '' != $prod_ln ? $prod_ln * 91.44 : 0 );
								$dm_ht = ( '' != $prod_ht ? $prod_ht * 91.44 : 0 );
								$dm_wd = ( '' != $prod_wd ? $prod_wd * 91.44 : 0 );
							}

							$dimentions_array = ['l' => $dm_ln, 'h' => $dm_ht, 'w' => $dm_wd];
						}
						$total_price_array = [ 'amount' => $item->get_total(), 'currency_code' => $currency ];
						$total_discount_array = [ 'amount' => '0.00', 'currency_code' => $currency ];
						$total_tax_array = [ 'amount' => $item->get_subtotal_tax(), 'currency_code' => $currency ];

						$line_items_arr[] =
						[
						'id' => $product_id,
						'admin_graphql_api_id' => '',
						'fulfillable_quantity' => 0,
						'fulfillment_service'  => '',
						'fulfillment_status'   => '',
						'gift_card' => '',
						'grams' => $grams,
						'image' => $product_image,
						'dimension' => $dimentions_array,
						'name'  => $item->get_name(),
						'price' => $item->get_total(),
						'price_set' => ['shop_money' => $total_price_array, 'presentment_money' => $total_price_array],
						'product_exists' => 1,
						'product_id' => $product_id,
						'properties' => [],
						'quantity'   => $item->get_quantity(),
						'requires_shipping' => 1,
						'sku' => $product->get_sku(),
						'taxable' => 0,
						'title' => $item->get_name(),
						'total_discount' => '',
						'total_discount_set' => ['shop_money' => $total_discount_array,    'presentment_money' => $total_discount_array],
						'variant_id' => ( $item->get_variation_id() > '0' ? $item->get_variation_id() : $product_id ),
						'variant_inventory_management' => 'woocom',
						'variant_title' => $item->get_name(),
						'vendor' => '',
						'tax_lines' =>
							[
								[
									'rate'  => '0.1',
									'title' => 'TAX',
									'channel_liable' => '',
									'price' => $item->get_subtotal(),
									'price_set' => ['shop_money' => $total_tax_array, 'presentment_money' => $total_tax_array]
								]
							],

						'duties' => [],
						'discount_allocations' => []

						];
						$orderlist[$j]['items'][] = $item['name'];
					}

					$orderlist[$j]['line_items'] = $line_items_arr;
					$j++;
					//break;
				}

			}

			//echo "<pre>"; 
			//print_r($orderlist);
			
			$postData = json_encode($orderlist);
			
			//echo $postData;
			
			$target_url = J_COURIERSPLEASE_JOOVII_WEBAPP_URL . '/exportbulkorder?shopid=' . $shop_id . '&accesstoken=' . $accesstoken;
			
			$args = ['httpversion' => '1.0', 'body'=> $postData, 'method'=> 'POST', 'timeout' => 3600 ];
			
			$content = wp_remote_post($target_url, $args);
			
			if ( is_wp_error( $content ) ) 
			{
				$error_message = $content->get_error_message();
				
				Joovii_couriersplease_log_actions("wp_remote_post ERROR inside JooviiCouriersplease_export_order_in_bulk >> " . print_r($content, true));
				
				$error = 1;
				$message = "Something went wrong [wp_remote_post] : " . $error_message;
			}
			else 
			{
				$response  = wp_remote_retrieve_body( $content );
				
				Joovii_couriersplease_log_actions("Order Bulk Export Response :: " . $response);
				
				$ret = json_decode($response, true);
				
				if( is_array($ret) )
				{
				  $error   = $ret['error'];
				  $message = $ret['message'];
				}
				else 
				{
					$error   = 1;
				    $message = "Unknown Error Occurred [$response] ";
				}
			}	
		}
		else 
		{
			// Show Error message
			$error = 1;
			$message = "Shop ID/Access Token missing";
		}
	
	}


	$action = isset($_SERVER['REQUEST_URI'])? sanitize_text_field($_SERVER['REQUEST_URI']) : '';
	$nonce = wp_create_nonce( 'joovi-wpcouriersplease-shipping-nonce' );
	
	if( $message )
	{
		echo "<div style='background:" . ($error ? '#c45a30':'#479345') . ";color:white;margin-top:10px;padding:4px;'>";
		echo ($error ? '<b>Error : </b> ' : '<b>Success : </b>') . $message ;
		echo "</div>";
	}
?>
    
	<form method="post" action="<?php echo esc_url($action); ?>&_nonce=<?php echo esc_html($nonce); ?>" enctype="multipart/form-data">
		<input type="hidden" name="rate" value="calculate">
		<div class="wrap">
			<h3 style="text-decoration:underline">Joovii Couriersplease Export Bulk Order</h3>
		</div>
		<table cellpadding="0" cellspacing="0" border="0"  width="100%" >
		  <tr>
			<td>
				<input type="submit" name="btnSubmit" value="Start Export" />
			</td>
		  </tr>
		</table>
	</form>
<?php
}
?>