<?php
$hook_to = 'woocommerce_admin_order_data_after_shipping_address';

$what_to_hook = 'joovii_couriersplease_order_shipment_update_webhook';
$prioriy = 111;
$num_of_arg = 1;    

// Frontend Orders
add_action($hook_to, $what_to_hook, $prioriy, $num_of_arg);
 
function joovii_couriersplease_order_shipment_update_webhook($order){
   

	$o = json_decode($order, true);
	$order_id = 0;
	
	if(is_array($o) && isset($o['id']))
	{
		$order_id = $o['id'];
	}
	else 
	{
		return;
	}

    $hpos_enabled = 0;

	if (class_exists(\Automattic\WooCommerce\Utilities\OrderUtil::class) ) {
		if (\Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled() ) {
			$hpos_enabled  = 1;
		}
	}
	
	// FIND if COURIERSPLEASE _REFERENCE exists or not 
	$couriersplease_reference = "";
	
	if ($hpos_enabled) 
	{
		$orderitem = wc_get_order($order_id);
		if( $orderitem )
		{
			$couriersplease_reference = $orderitem->get_meta('couriersplease_reference');
		}
		
	}
	else 
	{
		$orderitem = get_post($order_id);
		if( $orderitem )
		{
			$couriersplease_reference = get_post_meta($order_id, 'couriersplease_reference', true);;
		}
	}
	
	// if COURIERSPLEASE reference exists then we leave 
	if($couriersplease_reference != '')
	{
		return;
	}
	
    $_jset = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
	
	if( !isset($_jset['shop_id']) || !isset($_jset['accesstoken']) )
	{
		return '';
	}
	
	// Proceed
    $target_url = J_COURIERSPLEASE_JOOVII_WEBAPP_URL . "/getCourierspleaseShipmentDetails?shopid=" . $_jset['shop_id'] . "&securitycode=" . $_jset['accesstoken'] . "&orderid=$order_id";
					
	Joovii_couriersplease_log_actions('Fetching Shipment :: ' . $order_id . ', URL : ' . $target_url);				
	$args = [];
	$content = wp_remote_get($target_url);

	if ( is_wp_error( $content ) ) {
		$comm_status_msg = $content->get_error_message();
		$comm_status_err = 1;
		Joovii_couriersplease_log_actions('ERROR Fetch Shipment Details :: [wp_remote_get]:' . $comm_status_msg);
	}
	else
	{
		
		//Joovii_couriersplease_log_actions('COMMUNICATION STATUS [wp_remote_get] [URL : ' . $target_url . '] RECEIVED:' . $content['body']);
		$arr = json_decode( $content['body'], true );
		
		if( is_array($arr) && isset($arr['error']) && isset($arr['msg']) && $arr['error'] == 0 && isset($arr['data']))
		{
			$data = $arr['data'];
			
			if (is_array($data) && isset($data['security_code']) && ''!=$data['security_code'] &&
				isset($data['order_id']) && ''!=$data['order_id']) 
			{
				
				$security_code = $data['security_code'];
				
				$st = $_jset;
				
				//$order_id = $data['order_id'];
				
				if ($hpos_enabled) 
				{
					$orderitem = wc_get_order($order_id);
					
					if ($orderitem ) 
					{
						
						$receiver_email   = $orderitem->get_billing_email();
						$receiver_name    = $orderitem->get_shipping_first_name() . ' ' .
											$orderitem->get_shipping_last_name();
						
						if (isset($data['shipment_order_id'])) {
							$orderitem->update_meta_data('joovii_couriersplease_order_id', $data['shipment_order_id']);
						}
						
						if (isset($data['shipment_post'])) {
							$orderitem->update_meta_data('joovii_couriersplease_post', $data['shipment_post']);
						}
						
						if (isset($data['shipment_reference'])) {
							$orderitem->update_meta_data('joovii_couriersplease_reference', $data['shipment_reference']);
						}
						
						if (isset($data['shipment_response'])) {
							$orderitem->update_meta_data('joovii_couriersplease_response', $data['shipment_response']);
						}
						
						if (isset($data['shipment_tracking_url'])) {
							$orderitem->update_meta_data('joovii_couriersplease_tracking_url', $data['shipment_tracking_url']);
						}
						
						if (isset($data['label_url'])) {
							$orderitem->update_meta_data('joovii_couriersplease_label_url', $data['label_url']);
						}
						
						$orderitem->save();
						
						if (isset($data['shipment_response'])) {
							
							$joovii_couriersplease_response = json_decode(stripslashes($data['shipment_response']), true);
							
							JooviiCouriersplease_Send_Tracking_email_in_admin_order_edit($order_id, $receiver_email, $receiver_name, $joovii_couriersplease_response, 1);
						}
						
						Joovii_couriersplease_log_actions('Order ' . $order_id. ' Updated with Shipment Information');
					
					} else {
						
						Joovii_couriersplease_log_actions($order_id . ' : Order Not Found for shipment Update');
					}
				
				} else {
					
					$orderitem = get_post($order_id);
					
					if ($orderitem) 
					{
					
						$receiver_email = get_post_meta($order_id, '_billing_email', true);
						$receiver_name  = get_post_meta($order_id, '_shipping_first_name', true)
										. ' ' . get_post_meta($order_id, '_shipping_last_name', true);

						if (isset($data['shipment_order_id'])) {
							update_post_meta($order_id, 'joovii_couriersplease_order_id', $data['shipment_order_id']);
						}
						if (isset($data['shipment_post'])) {
							update_post_meta($order_id, 'joovii_couriersplease_post', $data['shipment_post']);
						}
						if (isset($data['shipment_reference'])) {
							update_post_meta($order_id, 'joovii_couriersplease_reference', $data['shipment_reference']);
						}
						if (isset($data['shipment_response'])) {
							update_post_meta($order_id, 'joovii_couriersplease_response', $data['shipment_response']);
						}
						if (isset($data['shipment_tracking_url'])) {
							update_post_meta($order_id, 'joovii_couriersplease_tracking_url', $data['shipment_tracking_url']);
						}
						if (isset($data['label_url'])) {
							update_post_meta($order_id, 'joovii_couriersplease_label_url', $data['label_url']);
						}

						Joovii_couriersplease_shipment_update_log_admin_side('Shipment Details Updated', $order_id);
						
						if (isset($data['shipment_response'])) {
							
							$joovii_couriersplease_response = json_decode(stripslashes($data['shipment_response']), true);
							
							JooviiCouriersplease_Send_Tracking_email_in_admin_order_edit($order_id, $receiver_email, $receiver_name, $joovii_couriersplease_response, 2);
						
						}

						Joovii_couriersplease_log_actions($order_id . ' Order Updated with Shipment Details...');
						
					} else {
						
						Joovii_couriersplease_log_actions($order_id . ' Order Not Found for shipment update...');
					
					}
				}
			} else {
				
				Joovii_couriersplease_log_actions($order_id . ' -Unauthorized- shipment update '); 
			
			}
		}
		
	}

}

function JooviiCouriersplease_Send_Tracking_email_in_admin_order_edit($order_id, $receiver_email, $receiver_name, $response, $mode = '' ) {
	
	$site_url = home_url();
	
	$joovii_couriersplease_setting = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));
    
	$reference = isset($response['shipment_reference']) ? $response['shipment_reference'] : '';
	if($reference == '')
	{
		$reference = isset($response['couriersplease_reference']) ? $response['couriersplease_reference'] : '';
	}
	
	$tracking_url = isset($response['shipment_tracking_url']) ? $response['shipment_tracking_url'] : '';
	if($tracking_url == '')
	{
		$tracking_url = isset($response['tracking_url']) ? $response['tracking_url'] : '';
	}
	
	// GET LAST email STATUS
	$sent = '';
	$orderitem = '';
	if( $mode == 1 )
	{
		$orderitem = wc_get_order($order_id);
		if( $orderitem )
		{
			$sent = $orderitem->get_meta('shipment_email_sent');
		}
	}
	else if( $mode == 2 )
	{
		$orderitem = get_post($order_id);
		if( $orderitem )
		{
			$sent = get_post_meta($order_id, 'shipment_email_sent', true);
		}
	}
	
	Joovii_couriersplease_shipment_update_log_admin_side("Inside JooviiCouriersplease_Send_Tracking_email_IN_ADMIN_ORDER_EDIT FUNCTION, [Sent:$sent] [Track Email Settings : " . 
										$joovii_couriersplease_setting['tracking_email'] . "]", $order_id);
	
	if ('yes' == $joovii_couriersplease_setting['tracking_email'] && $sent == '') 
	{
		
		// Update the Option 
		if( $mode == 1 )
		{
			if( $orderitem )
			{
				$orderitem->update_meta_data('shipment_email_sent', 'Yes');
				$orderitem->update_meta_data('shipment_email_sent_on', date("Y-m-d", time()) );
				Joovii_couriersplease_shipment_update_log_admin_side("Inside JooviiCouriersplease_Send_Tracking_email_IN_ADMIN_ORDER_EDIT, Updated Order Meta : Mode $mode", $order_id);
			}
		}
		else if( $mode == 2 )
		{
			if( $orderitem )
			{
				update_post_meta($order_id, 'shipment_email_sent', 'Yes');
				update_post_meta($order_id, 'shipment_email_sent_on', date("Y-m-d", time()) );
				Joovii_couriersplease_shipment_update_log_admin_side("Inside JooviiCouriersplease_Send_Tracking_email_IN_ADMIN_ORDER_EDIT, Updated Order Meta : Mode $mode", $order_id);
			}
		}
		
		
		$default_emailTemplateVal = '
		Hi {{customer_name}}
		An order you recently placed on our website has had its status changed.

		The status of order #{{order_no}} is now Shipped

		Shipment Tracking Numbers: {{tracking_number}}
		Shipment Tracking Links : {{tracking_link}}

		{{store_name}}';

		$to = $receiver_email;
		$subject = 'Your Order Has Been Updated (#' . $order_id . ')';
		$emailTemplateVal = get_option('woocommerce_JooviiCouriersplease_tracking_email_template');
		if ('' == trim($emailTemplateVal)) {
			$emailTemplateVal = $default_emailTemplateVal;
		}
		$body = str_replace('{{customer_name}}', ucwords($receiver_name), $emailTemplateVal);
		$body = str_replace('{{order_no}}', $order_id, $body);
		$body = str_replace('{{tracking_number}}', $reference, $body);
		$body = str_replace('{{tracking_link}}', $tracking_url, $body);
		$body = nl2br($body);
		$body = str_replace('{{store_name}}', $site_url, $body);

		$site_title = get_bloginfo('name');
		$site_admin_email = get_bloginfo('admin_email');


		$headers = array('Content-Type: text/html; charset=UTF-8');
		$headers[] = 'From: ' . $site_title . '<' . $site_admin_email . '>';

		wp_mail($to, $subject, $body, $headers);

		Joovii_couriersplease_shipment_update_log_admin_side(' tracking email sent [' . $to . ']  :: ' . $order_id, $order_id);
		Joovii_couriersplease_shipment_update_log_admin_side(' tracking email sent [subject] :: ' . $subject, $order_id);
		Joovii_couriersplease_shipment_update_log_admin_side(' tracking email sent [body] :: ' . $body, $order_id);
		Joovii_couriersplease_shipment_update_log_admin_side(' tracking email sent [header] :: ->' . $site_title . '--' .
									$site_admin_email . '<---', $order_id);
		Joovii_couriersplease_shipment_update_log_admin_side(' tracking email sent [emailTemplateVal] :: ' . $emailTemplateVal, $order_id);
		
		
		//UPDATE the order STATUS	
		$orderitem = new WC_Order($order_id);
		
		if ('processing'==$joovii_couriersplease_setting['change_order_status']) {
			$orderitem->update_status('processing');
			Joovii_couriersplease_shipment_update_log_admin_side(' update order status to processing :: ' . $order_id, $order_id);
		}
		if ('completed'==$joovii_couriersplease_setting['change_order_status']) {
			$orderitem->update_status('completed');
			Joovii_couriersplease_shipment_update_log_admin_side(' update order status to completed :: ' . $order_id, $order_id);
		}

	}

	
	//Joovii_couriersplease_shipment_update_log_admin_side('Order submitted from ' . $joovii_couriersplease_setting['book_shipment_on'].' completed.' .$postedby, $order_id);

}

function Joovii_couriersplease_shipment_update_log_admin_side($message, $orderid = '0') {
	$joovii_couriersplease_setting = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));
	if ('yes'==$joovii_couriersplease_setting['enable_log']) {
		global $wpdb;
		$table_name = $wpdb->prefix . 'joovii_courierspleaselogs';
		$wp_timezone = get_option('timezone_string');
		$wp_timezone = ( ''==$wp_timezone?'Australia/Sydney':$wp_timezone );
		$tz = new DateTimeZone($wp_timezone);
		$currentDateTime = new DateTime('now', $tz);
		$date = $currentDateTime->format('Y-m-d H:i:s');
		$wpdb->insert($table_name, array(
						'eventname'=>'null', 
						'orderid'=>$orderid,
						'logs'=>$message, 
						'timestamp'=> $date), 
						array('%s', '%d', '%s'));
	}
}

