<?php
/**
* This function converts the weight unit.
*
* @internal
*
* @return string
*/
function JooviiCouriersplease_getWeight ($weight, $pickupCountry ) {
	$wpWeightUnit = get_option('woocommerce_weight_unit');
	$joovii_couriersplease_weight_unit = 'kg';
	if ('AU' == $pickupCountry) {
		$joovii_couriersplease_weight_unit = 'kg';
	}
	if ( 'US' == $pickupCountry ) {
		$joovii_couriersplease_weight_unit = 'lbs';
	}
	if ( 'CA' == $pickupCountry) {
		$joovii_couriersplease_weight_unit = 'kg';
	}
	if ($weight > 0) {
		$finalWeight= wc_get_weight( $weight, $joovii_couriersplease_weight_unit, $wpWeightUnit );
	} else {
		$finalWeight = 0;
	}
	return round($finalWeight, 2);
}

/**
* This function converts the Dimension unit.
*
* @internal
*
* @return string
*/
function JooviiCouriersplease_getDimension ($dimension, $pickupCountry ) {
	$wpDimensionUnit = get_option('woocommerce_dimension_unit');
	//Joovii_couriersplease_log_actions(" wpDimensionUnit :: ". $wpDimensionUnit );
	$jooviiCourierspleaseDimensionUnit = 'm';
	if ( 'AU' == $pickupCountry) {
		$jooviiCourierspleaseDimensionUnit = 'm';
	}
	if ('US' == $pickupCountry) {
		$jooviiCourierspleaseDimensionUnit = 'in';
	}
	if ( 'CA' == $pickupCountry) {
		$jooviiCourierspleaseDimensionUnit = 'm';
	}
	if ($dimension > 0) {
		$finalDimension =  wc_get_dimension( $dimension, $jooviiCourierspleaseDimensionUnit, $wpDimensionUnit );
	} else {
		$finalDimension = 0;
	}
	//Joovii_couriersplease_log_actions(" finalDimension :: ". $finalDimension );
	return $finalDimension;
}

/**
* This function returns Couriersplease's maxWeightLimit.
*
* @internal
*
* @return string
*/
function JooviiCouriersplease_maxWeightLimit ($pickupCountry, $deliveryCountry ) {
	$maxWeight = J_COURIERSPLEASE_JOOVII_AU_MAX_DOMESTIC_WEIGHT;
	if ('AU' == $pickupCountry) {
		$maxWeight = J_COURIERSPLEASE_JOOVII_AU_MAX_DOMESTIC_WEIGHT;
		if (  'AU' != $deliveryCountry) {
			$maxWeight = J_COURIERSPLEASE_JOOVII_AU_MAX_INTERNATIONAL_WEIGHT;
		}
	}
	if ( 'US' == $pickupCountry ) {
		$maxWeight = J_COURIERSPLEASE_JOOVII_US_MAX_DOMESTIC_WEIGHT;
	}
	if ( 'CA' == $pickupCountry ) {
		$maxWeight = J_COURIERSPLEASE_JOOVII_CA_MAX_DOMESTIC_WEIGHT;
	}
	return $maxWeight;
}

/**
* This function returns Couriersplease's maxVolumeLimit.
*
* @internal
*
* @return string
*/
function JooviiCouriersplease_maxVolumeLimit ($pickupCountry, $deliveryCountry ) {
	$maxVolume = J_COURIERSPLEASE_JOOVII_AU_MAX_DOMESTIC_VOLUME;
	if ( 'AU' == $pickupCountry) {
		$maxVolume = J_COURIERSPLEASE_JOOVII_AU_MAX_DOMESTIC_VOLUME;
		if ( 'AU' != $deliveryCountry) {
			$maxVolume = J_COURIERSPLEASE_JOOVII_AU_MAX_INTERNATIONAL_VOLUME;
		}
	}
	if ( 'US' == $pickupCountry) {
		$maxVolume = J_COURIERSPLEASE_JOOVII_US_MAX_DOMESTIC_VOLUME;
	}
	if ( 'CA' == $pickupCountry) {
		$maxVolume = J_COURIERSPLEASE_JOOVII_CS_MAX_DOMESTIC_VOLUM;
	}
	return $maxVolume;
}

/**
* This function returns Couriersplease's RateArray.
*
* @internal
*
* @return array
*/
function JooviiCouriersplease_createRateArray ($package, $joovii_couriersplease_setting, $result, $counter ) {
	
	global $wpdb, $table_prefix;
	
	Joovii_couriersplease_log_actions(' JooviiCouriersplease_createRateArray function called ');

	$pickup_country = $joovii_couriersplease_setting['pickup_country'];
	
	$shipping_quote_markup = 0;
	$shipping_handling_fee = 0;

	// GET ZONE information
	if( !empty($package) )
	{
	  $zone = WC_Shipping_Zones::get_zone_matching_package( $package );
	  
	  if( !empty($zone) )
	  {		  
	     $zd = (array)$zone->get_data();
		 $zone_id = isset( $zd['id'] ) ? $zd['id'] : '';
		 if( $zone_id )
		 {
			$sql = "Select * from " . $table_prefix . "woocommerce_shipping_zone_methods where zone_id = $zone_id " . 
			"and method_id = 'joovii-couriersplease-zone' and is_enabled = 1 order by method_order limit 1;";
			
			$results = $wpdb->get_results($sql);
			
			if(!empty($results))
			{
				foreach($results as $res)
				{
					$instance_id = $res->instance_id;
					
					$setting_name = "woocommerce_joovii-couriersplease-zone_" . $instance_id . "_settings";
					$opt = get_option($setting_name);
					
					if( !empty($opt) && is_array($opt) )
					{
						if(isset($opt['quote_markup']) && $opt['quote_markup']!= '')
						{
							$shipping_quote_markup = $opt['quote_markup'];
						}
						if(isset($opt['shipping_handling_fee']) && $opt['shipping_handling_fee']!= '')
						{
							$shipping_handling_fee = $opt['shipping_handling_fee'];
						}
						
						Joovii_couriersplease_log_actions("FOUND ZONE details : [$shipping_quote_markup] [$shipping_handling_fee]");
					}
				}
			}				
		 }
	  }
	}
	
	
	$jooviiCourierspleasecost=0;
	if (isset($result[0])) {
		$jooviiCourierspleasecost = $result[0]['quote']['gross']['amount'];
	}
	// Tax calculation start
	$taxesArray = '';
	$shipping_handling_fee_tax = 0;
	$shipping_handling_fee_net = $shipping_handling_fee ? $shipping_handling_fee : 0;

	if ( 'AU' == $pickup_country) {
		$taxEnabled= get_option('woocommerce_calc_taxes');
		$taxClassExists = WC_Tax::get_rates();
		//print_r($taxClassExists);
		$calculatetax =1;
		if ( !empty($taxClassExists) && $calculatetax == 1 ) {
			Joovii_couriersplease_log_actions(' taxClassExists :: ' . print_r($taxClassExists, true) . ' ');
			if ( 'yes' == $taxEnabled) {
				Joovii_couriersplease_log_actions(' shipping TAX applied ');
				if (isset($result[0])) {
					$jooviiCourierspleasecost = $result[0]['quote']['net']['amount'];
				}
				$shipping_handling_fee_add = $shipping_handling_fee_net;
				$ratex = WC_Tax::_get_tax_rate('111');
				if ( !empty($ratex) ) {
					$tax_rate_id = $ratex['tax_rate_id'];
				} else {
					$taxkey =array_keys($taxClassExists);
					$taxClasspriority = WC_Tax::_get_tax_rate($taxkey['0']);
					$taxesArray1 = array(
						'tax_rate_id' => '111',
						'tax_rate_country' => '',
						'tax_rate_state' => '',
						'tax_rate' => 0,
						'tax_rate_name' => 'ShippingTax',
						'tax_rate_priority' => ( $taxClasspriority['tax_rate_priority'] + 1 ),
						'tax_rate_compound' => 0,
						'tax_rate_shipping' => 1,
						'tax_rate_order' => 1,
						'tax_rate_class' => '',
					);
					$tax_rate_id = WC_Tax::_insert_tax_rate( $taxesArray1 );
				}
				$taxesArray = array($tax_rate_id => $result[0]['quote']['tax']['amount'] + $shipping_handling_fee_tax);
				Joovii_couriersplease_log_actions('Final tax(CourierspleaseTax + handling_fee_tax)  : ' . $result[0]['quote']['tax']['amount'] . ' + ' . $shipping_handling_fee_tax);
			} else {
				$taxesArray = false;
				if (isset($result[0])) {
					$jooviiCourierspleasecost = $result[0]['quote']['gross']['amount'];
				}
				$shipping_handling_fee_add = $shipping_handling_fee;
				Joovii_couriersplease_log_actions('  shipping TAX --->NOT<---- applied [for taxEnabled = no] ');
			}
		} else {
			$taxesArray = false;
			if (isset($result[0])) {
				$jooviiCourierspleasecost = $result[0]['quote']['gross']['amount'];
			}
			$shipping_handling_fee_add = $shipping_handling_fee;
			Joovii_couriersplease_log_actions('  shipping TAX --->NOT<---- applied [for taxClassExists = no] ');
		}
	} else {
		$taxesArray = false;
		if (isset($result[0])) {
			$jooviiCourierspleasecost = $result[0]['quote']['gross']['amount'];
		}
		$shipping_handling_fee_add = $shipping_handling_fee;
		Joovii_couriersplease_log_actions('  shipping TAX --->NOT<---- applied [for US]');
	}
	// Tax calculation end
	Joovii_couriersplease_log_actions('  Final cost without tax(courierspleasecost + handling_fee + markup)  : ' . $jooviiCourierspleasecost . ' + ' . $shipping_handling_fee_add . ' + ' . ( $jooviiCourierspleasecost * $shipping_quote_markup/100 ) );
	
	$plan_name = str_replace(' ', '-', strtolower($result[0]['plan_name']));
	
	$rate = array(  
	   'id'       => 'joovii-couriersplease-zone_' . $counter ,
	   'label'    => $result[0]['plan_name'],
	   'cost'     => ( $jooviiCourierspleasecost + $shipping_handling_fee_add + ( $jooviiCourierspleasecost * $shipping_quote_markup/100 ) ),
	   'taxes'    => $taxesArray,
	   'calc_tax' => 'per_order' 
	);
	
	if ( 0 == $rate['cost'] ) {
		return;
	}
	//Joovii_couriersplease_log_actions(" result :: ".print_r($result,true)." ");
	Joovii_couriersplease_log_actions(' JooviiCouriersplease_createRateArray function ended :: Rate -> ' . print_r($rate, true) . ' ');
	return $rate;
}

/**
* This function returns Couriersplease's DownloadLabelLink.
*
* @internal
*
* @return array
*/
function Joovii_couriersplease_get_download_label_link($jooviiCouriersplease_order_id) {
	return true;
}
