<?php
add_filter( 'woocommerce_shipping_methods', 'Joovii_couriersplease_add_shipping_zone_method' );
add_filter( 'woocommerce_shipping_calculator_enable_city', '__return_true'  );
add_action( 'woocommerce_shipping_init', 'Joovii_couriersplease_Shipping_Zone_Method' );

add_action( 'in_admin_footer', 'Joovii_couriersplease_my_custom_js_one' );
add_action( 'wp_enqueue_scripts', 'Joovii_couriersplease_theme_enqueue_scripts' );
add_action( 'wp_footer', 'Joovii_couriersplease_theme_autocomplete_js' );
add_action ( 'wp_ajax_nopriv_courierspleasejooviicityziplookup', 'Joovii_couriersplease_getcityziplookup' );
add_action ( 'wp_ajax_courierspleasejooviicityziplookup', 'Joovii_couriersplease_getcityziplookup' );

function Joovii_couriersplease_my_custom_js_one($hook) {
	$srt = '<script type="text/javascript">
	jQuery(\'#woocommerce_couriersplease_process_as_couriersplease_order\').css(\'height\',\'90px\');
	</script> ';
	//echo esc_html( $srt );
}

function Joovii_couriersplease_theme_enqueue_scripts() {
	$joovii_couriersplease_setting  = 	maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
	if ( isset($joovii_couriersplease_setting['enable_addressmatch']) && 'yes' == $joovii_couriersplease_setting['enable_addressmatch'] ) {
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-autocomplete' );
	}
}


function Joovii_couriersplease_theme_autocomplete_js() {
	$joovii_couriersplease_setting  = 	maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
	if ( isset($joovii_couriersplease_setting['enable_addressmatch']) && 'yes' == $joovii_couriersplease_setting['enable_addressmatch'] )
	{
		// City ZIP Look UP CODE
		?>

		<style type="text/css">
		.cityziploader{ background: url(<?php echo esc_html(plugins_url( '', __FILE__ )); ?>/loader.gif) !important; background-repeat: no-repeat !important; background-position: right !important; }
		.ui-autocomplete {max-height: 300px;overflow-y: auto;overflow-x: hidden; position: absolute; top: 100%; left: 0; z-index: 1000; float: left; display: none; min-width: 160px; padding: 4px; margin: 0 0 10px 25px; list-style: none; background-color: #ffffff; border-color: #ccc; border-color: rgba(0, 0, 0, 0.2); border-style: solid; border-width: 1px; -webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px; -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2); -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2); box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2); -webkit-background-clip: padding-box; -moz-background-clip: padding; background-clip: padding-box; *border-right-width: 2px; *border-bottom-width: 2px; }
		.ui-autocomplete li:hover { color:red; }
		.ui-menu-item > a.ui-corner-all { display: block; padding: 3px 15px; clear: both; font-weight: normal; line-height: 18px; color: #555555; white-space: nowrap; text-decoration: none; }
		.ui-state-hover, .ui-state-active { color: #ffffff; text-decoration: none; background-color: #0088cc; border-radius: 0px; -webkit-border-radius: 0px; -moz-border-radius: 0px; background-image: none; }
		.ui-helper-hidden-accessible { display: none;}
		</style>
		<script type="text/javascript">

			function selectElements_joovii(pagename, pagetype, ui){

				var cc_name = '#'+pagename+""+pagetype+'_postcode';

				if( jQuery( cc_name ).length ) {


					jQuery( '#'+pagename+''+pagetype+'_postcode').val( ui.item.zip);
					jQuery( '#'+pagename+''+pagetype+'_city' ).val( ui.item.city );
					if(jQuery( '#'+pagename+''+pagetype+'_country' ).val() == 'AU') {
						jQuery("#"+pagename+""+pagetype+"_state option[value='"+ui.item.statecode+"']").remove();
						jQuery("#"+pagename+""+pagetype+"_state").append("<option value='"+ui.item.statecode+"' selected >"+ui.item.statename+"</option>");
					}else{
						if(ui.item.statename != ''){
							jQuery("#"+pagename+""+pagetype+"_state option[value='"+ui.item.statecode+"']").remove();
							jQuery("#"+pagename+""+pagetype+"_state").append("<option value='"+ui.item.statecode+"' selected >"+ui.item.statename+"</option>");
						}
					}

				}else{

				}

			}

		  function dynamicSource_joovii( request, response , pagename, pagetype, ) {
				var cc_name = '#'+pagename+""+pagetype+'_country';
				jcall_country='au';
				if( jQuery( cc_name ).length ) {
					jcall_country=jQuery( cc_name ).val();
				}else{
					//cc_name = '#components-form-token-input-'+pagename;
					cartdata_joovii = wp.data.select('wc/store/cart').getCartData();
					if(pagetype =='shipping'){
						jcall_country=cartdata_joovii.shippingAddress.country
					}
					if(pagetype =='billing'){
						jcall_country=cartdata_joovii.billingAddress.country
					}
				}

				jQuery.ajax({
				  url: "<?php echo esc_html(admin_url( 'admin-ajax.php' )); ?>",
				  dataType: "json",
				  data: {action: 'courierspleasejooviicityziplookup', q: request.term+'countrycode'+jcall_country },
				  success: function( data ) { 
				     console.log('CItyZipLookUp SUCCESS');
					 response( data );
				  }
				});
			}

			jQuery(document).ready(function($){

				// SET a TIMEOUT
				setTimeout(function(){
					// FOR OLD WORDPRESS
					// CART SHIPPING CITY
					if( jQuery( 'input[name="calc_shipping_city"]' ).length ) {
						jQuery( 'input[name="calc_shipping_city"]' ).autocomplete({
								source: function( request, response ) { dynamicSource_joovii( request, response, 'calc', '_shipping' ); },
								minLength: 2,
								search: function (e, u) {jQuery(this).addClass('cityziploader');},
								response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
								open    : function(){jQuery(this).removeClass('cityziploader');},
								focus: function( event, ui ) {jQuery( "#calc_shipping_city" ).val(  ui.item.city ); return false; },
								select: function(event, ui) { selectElements_joovii('calc', '_shipping', ui); return false; }
						});
					}

					// CART SHIPPING POSTCODE
					if ( jQuery( 'input[name="calc_shipping_postcode"]' ).length ) {
						jQuery( 'input[name="calc_shipping_postcode"]' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, 'calc', '_shipping' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( "#calc_shipping_postcode" ).val(  ui.item.city ); return false; },
							select: function(event, ui) { selectElements_joovii('calc', '_shipping', ui); return false; }
						});
					}

					// CHECKOUT billing POSTCODE
					if( jQuery( 'input[name="billing_postcode"]' ).length ) {
						jQuery( 'input[name="billing_postcode"]' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, '', 'billing' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( "#billing_postcode" ).val(  ui.item.city ); return false; },
							select: function(event, ui) { selectElements_joovii('', 'billing', ui); jQuery('body').trigger('update_checkout'); return false; }
						});
					}
					// CHECKOUT -------------------------------------------------------------------------------------------------`
					if( jQuery( 'input[name="billing_city"]' ).length ) {
						jQuery( 'input[name="billing_city"]' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, '', 'billing' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( "#billing_city" ).val(  ui.item.city ); return false; },
							select: function(event, ui) { selectElements_joovii('', 'billing', ui); jQuery('body').trigger('update_checkout'); return false; }
						});
					}

					// ----- checkout shipping
					// SHIPPING POSTCODE
					if( jQuery( 'input[name="shipping_postcode"]' ).length ) {
						jQuery( 'input[name="shipping_postcode"]' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, '', 'shipping' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( "#shipping_postcode" ).val(  ui.item.city ); return false; },
							select: function(event, ui) { selectElements_joovii('', 'shipping', ui); jQuery('body').trigger('update_checkout'); return false; }
						});
					}

					if( jQuery( 'input[name="shipping_city"]' ).length ) {
						jQuery( 'input[name="shipping_city"]' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, '', 'shipping' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( "#shipping_city" ).val(  ui.item.city ); return false; },
							select: function(event, ui) { selectElements_joovii('', 'shipping', ui); jQuery('body').trigger('update_checkout'); return false; }
						});
					}

					//// FOR NEW WORDPRESS VERSIONS ///////////////////////////////
					var cart_city = jQuery(".wc-block-components-address-form__city input");
					if( cart_city.length ) {
						console.log( ".wc-block-components-address-form__city input length" );
						jQuery( cart_city[0] ).autocomplete({
								source: function( request, response ) { dynamicSource_joovii( request, response, 'calc', '_shipping' ); },
								minLength: 2,
								search: function (e, u) {jQuery(this).addClass('cityziploader');},
								response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
								open    : function(){jQuery(this).removeClass('cityziploader');},
								focus: function( event, ui ) {jQuery( cart_city[0] ).val(  ui.item.city ); return false; },
								select: function(event, ui) { selectElements_joovii('calc', '_shipping', ui); return false; }
						});
					}

					// CART SHIPPING POSTCODE
					var cart_postcode = jQuery(".wc-block-components-address-form__postcode input");
					if ( cart_postcode.length ) {
						jQuery( 'input[name="calc_shipping_postcode"]' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, 'calc', '_shipping' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( cart_postcode[0] ).val(  ui.item.city ); return false; },
							select: function(event, ui) { selectElements_joovii('calc', '_shipping', ui); return false; }
						});
					}

					// ----- CHECKOUT FIELDS -------------------woocom-9------------------------------------
					// Billing CITY
					if( jQuery( 'input#0-city' ).length ){
						jQuery( 'input#0-city' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, '0', 'cart' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( "input#0-city" ).val(  ui.item.city ); return false; },
							select: function(event, ui) {

								wp.data.dispatch('wc/store/cart').setBillingAddress({'postcode': ui.item.zip });
								wp.data.dispatch('wc/store/cart').setBillingAddress({'city': ui.item.city });
								wp.data.dispatch('wc/store/cart').setBillingAddress({'state': ui.item.statecode });

								jQuery('body').trigger('update_checkout');
								return false;
							}
						});
					}

					if( jQuery( 'input#0-postcode' ).length ){
						jQuery( 'input#0-postcode' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, '0', 'cart' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( "input#0-postcode" ).val(  ui.item.city ); return false; },
							select: function(event, ui) {

								wp.data.dispatch('wc/store/cart').setBillingAddress({'postcode': ui.item.zip });
								wp.data.dispatch('wc/store/cart').setBillingAddress({'city': ui.item.city });
								wp.data.dispatch('wc/store/cart').setBillingAddress({'state': ui.item.statecode });

								jQuery('body').trigger('update_checkout');
								return false;
							}
						});
					}

					if( jQuery( 'input#billing-city' ).length ){
						jQuery( 'input#billing-city' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, '2', 'billing' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( "input#billing-city" ).val(  ui.item.city ); return false; },
							select: function(event, ui) {

								wp.data.dispatch('wc/store/cart').setBillingAddress({'postcode': ui.item.zip });
								wp.data.dispatch('wc/store/cart').setBillingAddress({'city': ui.item.city });
								wp.data.dispatch('wc/store/cart').setBillingAddress({'state': ui.item.statecode });

								jQuery('body').trigger('update_checkout', { update_shipping_method: true });
								return false;
							}
						});
					}

					// Billing POSTCODE
					if( jQuery( 'input#billing-postcode' ).length ){
						jQuery( 'input#billing-postcode' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, '2', 'billing' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( 'input#billing-postcode' ).val(  ui.item.zip ); return false; },
							select: function(event, ui) {

								wp.data.dispatch('wc/store/cart').setBillingAddress({'postcode': ui.item.zip });
								wp.data.dispatch('wc/store/cart').setBillingAddress({'city': ui.item.city });
								wp.data.dispatch('wc/store/cart').setBillingAddress({'state': ui.item.statecode });

								jQuery('body').trigger('update_checkout', { update_shipping_method: true });
								return false;
							}
						});
					}

					// ----- checkout shipping
					// SHIPPING CITY
					if( jQuery( 'input#shipping-city' ).length ){
						jQuery( 'input#shipping-city' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, '0', 'shipping' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( "input#shipping-city" ).val(  ui.item.city ); return false; },
							select: function(event, ui) {

								wp.data.dispatch('wc/store/cart').setShippingAddress({'postcode': ui.item.zip });
								wp.data.dispatch('wc/store/cart').setShippingAddress({'city': ui.item.city });
								wp.data.dispatch('wc/store/cart').setShippingAddress({'state': ui.item.statecode });

								jQuery('body').trigger('update_checkout', { update_shipping_method: true });
								return false;
							}
						});
					}

					// SHIPPING POSTCODE
					if( jQuery( 'input#shipping-postcode' ).length ){
						jQuery( 'input#shipping-postcode' ).autocomplete({
							source: function( request, response ) { dynamicSource_joovii( request, response, '0', 'shipping' ); },
							minLength: 2,
							search: function (e, u) {jQuery(this).addClass('cityziploader');},
							response: function (e, u) { jQuery(this).removeClass('cityziploader'); },
							open    : function(){jQuery(this).removeClass('cityziploader');},
							focus: function( event, ui ) {jQuery( 'input#shipping-postcode' ).val(  ui.item.zip ); return false; },
							select: function(event, ui) {

								wp.data.dispatch('wc/store/cart').setShippingAddress({'postcode': ui.item.zip });
								wp.data.dispatch('wc/store/cart').setShippingAddress({'city': ui.item.city });
								wp.data.dispatch('wc/store/cart').setShippingAddress({'state': ui.item.statecode });

								//jQuery('body').trigger('update_checkout');
								jQuery('body').trigger('update_checkout', { update_shipping_method: true });

								//countryJ = wp.data.select('wc/store/cart').getCartData();
								//console.log('-country->'+countryJ.shippingAddress.country);
								return false;
							}
						});
					}
					
					console.log('EVENTs set in Timeout');
					
				}, 3000); 
				// SetTimeout Ends HEre 

			});
		</script>

		<?php
	}
}

/**
* This function adds shipping rates at checkout.
*
* @internal
*
* @return array
*/
function Joovii_couriersplease_add_shipping_zone_method( $methods ) {
	$methods['joovii-couriersplease-zone'] = 'Joovii_couriersplease_Shipping_Zone_Method';
	return $methods;
}

/**
* This function adds shipping rates at checkout.
*
* @internal
*
* @return array
*/
function Joovii_couriersplease_Shipping_Zone_Method() {
	$assign_permission = 'customer';
	if ( !class_exists('Joovii_couriersplease_Shipping_Zone_Method') ) {
		class Joovii_couriersplease_Shipping_Zone_Method extends WC_Shipping_Method {
			/**
			* This function adds shipping rates at checkout.
			*
			*  @internal
			* @return array
			**/
			public function __construct ( $instance_id = 0 ) {
				$this->id = 'joovii-couriersplease-zone';
				$this->instance_id = absint( $instance_id );
				$this->method_title = __( 'Joovii Couriersplease', 'joovii' );
				$this->method_description = __( 'This app provides the ultimate connectivity between WooCommerce and Couriersplease.', 'joovii' );
				$this->supports = array( 'shipping-zones', 'instance-settings', 'instance-settings-modal');
				$this->init();
				$title = $this->get_option('title');
				$this->title = !empty( $title ) ? $title : __( 'Joovii Couriersplease Shipping', 'joovii' );
			}
			/**
			* * This function adds shipping rates at checkout.
			* *
			* * @internal
			* *
			* * @return array
			* */
			public function init() {

				$this->init_settings();
				$this->init_form_fields();

				// Define user set variables.
				//$this->quote_markup      = $this->get_option( 'quote_markup' );
				//$this->handling_fees       = $this->get_option('handling_fees');

				add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
			}

			public function init_form_fields() {

				$instance_id = $this->instance_id;
				$settings_name = "woocommerce_joovii-couriersplease-zone_". $instance_id . "_settings";
				$option = maybe_unserialize(get_option($settings_name));
				//$option = $option != '' ? unserialize( $option ) : [];

				$this->instance_form_fields = array(
					'quote_markup'            => array(
						'title'       => __( 'Shipping Quote Markup %', 'woocommerce' ),
						'type'        => 'text',
						'description' => __( 'Shipping Quote Markup %', 'woocommerce' ),
						'default'     => (is_array($option) && isset($option['quote_markup']) ? $option['quote_markup'] : 0 ),
						'placeholder' => __( 'e.g. 1', 'woocommerce' ),
						'desc_tip'    => true,
					),
					'shipping_handling_fee'            => array(
						'title'       => __( 'Additional Handling Fees Applied', 'woocommerce' ),
						'type'        => 'text',
						'description' => __( 'Additional Handling Fees Applied', 'woocommerce' ),
						'default'     => (is_array($option) && isset($option['shipping_handling_fee']) ? $option['shipping_handling_fee'] : 0 ),
						'placeholder' => __( 'e.g. 5', 'woocommerce' ),
						'desc_tip'    => true,
					),
				);
			}

			public function get_instance_form_fields() {
				return parent::get_instance_form_fields();
			}
			/**
			* * This function adds shipping rates at checkout.
			* *
			* * @internal
			* *
			* * @return array
			* */
			public function calculate_shipping( $package = array() )
			{
					Joovii_couriersplease_log_actions("STARTED calculate_shipping in ZONE :: " . print_r($package, true));

					$weight = 0;
					$volume	= 0;
					global $woocommerce;
					$s_s = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );

					$pickupCountry    = isset($s_s['pickup_country']) ? trim($s_s['pickup_country']) : ''; 
					$pickupSuburb 	  = isset($s_s['pickup_suburb']) ? trim($s_s['pickup_suburb']) : ''; 
					$pickupPostcode   = isset($s_s['pickup_postcode']) ? trim($s_s['pickup_postcode']) : ''; 
					if ( empty($pickupSuburb ) || empty($pickupPostcode) ) {
						//return ;
					} 
					
					$deliveryCountry  = trim($package['destination']['country']);

					$maxWeight = JooviiCouriersplease_maxWeightLimit ($pickupCountry, trim($package['destination']['country']) );
					$maxVolume = JooviiCouriersplease_maxVolumeLimit ($pickupCountry, trim($package['destination']['country']) );
					$cartChkout=[];
					$wpWeightUnit = get_option('woocommerce_weight_unit');
					$wpDimensionUnit = get_option('woocommerce_dimension_unit');

					$city = get_option('woocommerce_store_city');
					
					/* if(trim($city) == '')
					{
						$city = isset($s_s['pickup_suburb']) ? trim($s_s['pickup_suburb']) : '';
					} */
					
					/* $cartChkout['rate']['origin'] = [
						'country' => $s_s['pickup_country'],
						'postal_code' => $s_s['pickup_postcode'],
						'province' => $s_s['sender_state'],
						'city' => $city,
						'name' =>$s_s['sender_name'],
						
						'address1' => $s_s['sender_address'],
						'address2' => '',
						'address3' => '',
						
						'latitude' =>'', 'longitude' =>'',
						'phone' =>$s_s['sender_contact_number'],
						'fax' =>$s_s['sender_contact_number'],
						'email' => get_option('admin_email'),
						'address_type' =>'',
						'company_name' =>$s_s['sender_name']
					]; */
					
					if( $pickupPostcode == '' )
					{
						$pickupPostcode = get_option('woocommerce_store_postcode');
					}
					
					$cartChkout['rate']['origin'] = [
						'country'     => isset($s_s['country']) ? trim($s_s['country']) : '',
						'postal_code' => isset($s_s['zip']) ? trim($s_s['zip']) : $pickupPostcode,
						'province'    => isset($s_s['province']) ? trim($s_s['province']) : '',  
						'city'        => $city,
						'name'        => isset($s_s['name']) ? trim($s_s['name']) : '',
						'address1'    => isset($s_s['address1']) ? trim($s_s['address1']) : '', 
						'address2'    => '',
						'address3'    => '',
						'latitude'  => '', 
						'longitude' => '',
						'phone'     => '9898989898',
						'fax' 	    => '9898989898',
						'email'     => get_option('admin_email'),
						'address_type' => '',
						'company_name' => isset($s_s['name']) ? trim($s_s['name']) : ''
					];

					$c_d = WC()->session->get('customer');

					$dest = isset($package['destination']) ? $package['destination'] : [];

					$country = isset($dest['country']) ? $dest['country'] : ( isset($c_d['shipping_country']) ? $c_d['shipping_country'] : '' );
					$state = isset($dest['state']) ? $dest['state'] : ( isset($c_d['shipping_state']) ? $c_d['shipping_state'] : '' );
					$postcode = isset($dest['postcode']) ? $dest['postcode'] : ( isset($c_d['shipping_postcode']) ? $c_d['shipping_postcode'] : '' );
					$city = isset($dest['city']) ? $dest['city'] : ( isset($c_d['shipping_city']) ? $c_d['shipping_city'] : '' );
					$address = isset($dest['address']) ? $dest['address'] : ( isset($c_d['shipping_address']) ? $c_d['shipping_address'] : '' );
					$address1 = isset($dest['address_1']) ? $dest['address_1'] : ( isset($c_d['shipping_address_1']) ? $c_d['shipping_address_1'] : '' );
					$address2 = isset($dest['address_2']) ? $dest['address_2'] : ( isset($c_d['shipping_address_2']) ? $c_d['shipping_address_2'] : '' );
					
					// Remove Duplicate Lines
					if(strtolower(trim($address2)) == strtolower(trim($address1)) )
					{
						$address2 = '';
					}
					
					if(strtolower(trim($address)) == strtolower(trim($address1)) )
					{
						$address1 = '';
					}

					$cartChkout['rate']['destination'] = [
						'country'     	=> $country,
						'postal_code' 	=> $postcode,
						'province'   	=> $state,
						'city' 			=> $city,
						'address1' 		=> $address,
						'address2' 		=> $address1,
						'address3' 		=> $address2,

						'name' 			=> trim( 
											   ( isset($c_d['shipping_first_name']) ? $c_d['shipping_first_name'] : '' )
											   .
											   ( isset($c_d['shipping_last_name']) ? ' ' . $c_d['shipping_last_name'] : '' )
										   )
										    ,
						'latitude' 		=> '',
						'longitude' 	=> '',
						'phone' 		=> isset($c_d['shipping_phone']) ? $c_d['shipping_phone'] : '',
						'fax' 			=> isset($c_d['shipping_phone']) ? $c_d['shipping_phone'] : '',
						'email' 		=> isset($c_d['email']) ? $c_d['email'] : '',
						'address_type'  => '',
						'company_name'  => isset($c_d['shipping_company']) ? $c_d['shipping_company'] : $s_s['sender_name']
					];
					
					if(trim($cartChkout['rate']['destination']['address2']) == '' &&  trim($cartChkout['rate']['destination']['address3']) != '')
					{
						$cartChkout['rate']['destination']['address2'] = trim($cartChkout['rate']['destination']['address3']);
						$cartChkout['rate']['destination']['address3'] = '';
					}
					
					$items = $woocommerce->cart->get_cart();
					$packageArr = array();
					$cartTotalQuatity = 0;
					$cartTotalweight = 0;
					foreach ( $package['contents'] as $item_id => $values ) 
					{
						//foreach ( $items as $item_id => $values ) {
						//Joovii_couriersplease_log_actions(" cart-p :".$item_id.": ". print_r($values,true) );
						$_product = $values['data'];
						
						// ----------------------------------------------------------------------------
						// BUNDLE PRODUCT HANDLING (Supports multiple plugins)
						// ----------------------------------------------------------------------------
						if (
							($_product->is_type('bundle') && method_exists($_product, 'get_bundled_items')) ||
							(isset($values['bundled_by']) && isset($values['bundled_item_id'])) // fallback for plugins using these keys
						) 
						{
							$bundled_items = method_exists($_product, 'get_bundled_items')
								? $_product->get_bundled_items()
								: [$values];

							foreach ($bundled_items as $bundled_item) 
							{
								$child_product = method_exists($bundled_item, 'get_product') ? $bundled_item->get_product() : $bundled_item['data'];
								$child_quantity = isset($bundled_item['quantity'])
									? $bundled_item['quantity'] * $values['quantity']
									: ($values['quantity'] ?? 1);

								$weightP = JooviiCouriersplease_getWeight($child_product->get_weight(), $pickupCountry);

								if ($weightP > 0) 
								{
									$weight += $weightP * $child_quantity;
									$cartTotalQuatity += $child_quantity;
									$cartTotalweight += $child_product->get_weight() * $child_quantity;

									$volumeP = 0;
									$l = $w = $h = 5;

									if (isset($s_s['volume_param']) && $s_s['volume_param'] === 'yes') 
									{
										if ($child_product->get_length() > 0) {
											$volumnP_l = JooviiCouriersplease_getDimension($child_product->get_length(), $pickupCountry);
											if ($wpDimensionUnit === 'm') {
												$l = $volumnP_l * 100;
											} elseif ($wpDimensionUnit === 'in') {
												$l = $volumnP_l * 2.54;
											} elseif ($wpDimensionUnit === 'ft') {
												$l = $volumnP_l * 30.48;
											} else {
												$l = $volumnP_l * 100;
											}
										}
										if ($child_product->get_width() > 0) {
											$volumnP_w = JooviiCouriersplease_getDimension($child_product->get_width(), $pickupCountry);
											if ($wpDimensionUnit === 'm') {
												$w = $volumnP_w * 100;
											} elseif ($wpDimensionUnit === 'in') {
												$w = $volumnP_w * 2.54;
											} elseif ($wpDimensionUnit === 'ft') {
												$w = $volumnP_w * 30.48;
											} else {
												$w = $volumnP_w * 100;
											}
										}
										if ($child_product->get_height() > 0) {
											$volumnP_h = JooviiCouriersplease_getDimension($child_product->get_height(), $pickupCountry);
											if ($wpDimensionUnit === 'm') {
												$h = $volumnP_h * 100;
											} elseif ($wpDimensionUnit === 'in') {
												$h = $volumnP_h * 2.54;
											} elseif ($wpDimensionUnit === 'ft') {
												$h = $volumnP_h * 30.48;
											} else {
												$h = $volumnP_h * 100;
											}
										}
										$volumeP = $l * $w * $h;
										$volume += $volumeP * $child_quantity;
									}

									if ($weightP > $maxWeight) 
									{
										if (isset($s_s['warningtext_enable']) && $s_s['warningtext_enable'] === 'yes') {
											wc_add_notice(__('Weight Exceeds Max Allowed Weight', 'woocommerce'));
										}
										return;
									}
									if ($volumeP > $maxVolume) 
									{
										if (isset($s_s['warningtext_enable']) && $s_s['warningtext_enable'] === 'yes') {
											wc_add_notice(__('Volume Exceeds Max Allowed Volume', 'woocommerce'));
										}
										return;
									}

									for ($i = 0; $i < $child_quantity; $i++) 
									{
										$packageArr[] = ['w' => $weightP, 'v' => $volumeP];
									}

									$grams = ($wpWeightUnit === 'kg') ? $weightP * 1000 : (($wpWeightUnit === 'lbs') ? $weightP * 453.6 : $weightP * 1000);

									$cartChkout['rate']['items'][] = [
										'name' => $child_product->get_name(),
										'sku' => $child_product->get_sku(),
										'quantity' => $child_quantity,
										'grams' => $grams,
										'dimension' => ['l' => $l, 'w' => $w, 'h' => $h],
										'price' => $child_product->get_price(),
										'vendor' => '',
										'requires_shipping' => $child_product->get_shipping_class_id(),
										'taxable' => $child_product->get_tax_status(),
										'fulfillment_service' => '',
										'properties' => [],
										'product_id' => $child_product->get_parent_id() == 0 ? $child_product->get_id() : $child_product->get_parent_id(),
										'variant_id' => $child_product->get_id()
									];
								} else {
									if (isset($s_s['warningtext_enable']) && $s_s['warningtext_enable'] === 'yes') {
										wc_add_notice(__('Weight is lesser than 0', 'woocommerce'));
									}
									return;
								}
							}

							continue;
						}
						
						$weightP = JooviiCouriersplease_getWeight ( $_product->get_weight(), $pickupCountry );
						$weight = $weight + $weightP * $values['quantity'];
						$cartTotalQuatity = $cartTotalQuatity + $values['quantity'];
						if ( $_product->get_weight()>0 ) {
							$cartTotalweight = $cartTotalweight + ( $_product->get_weight() * $values['quantity'] );
						}
						Joovii_couriersplease_log_actions(' get_weight/weight [1] : ' . $_product->get_weight() . '--' . $weightP );
						Joovii_couriersplease_log_actions(' quantity/weight [2] : ' . $values['quantity'] );
						Joovii_couriersplease_log_actions(' weight/weight [3] : ' . $weight );
						$volumeP = 0;
						if ( isset($s_s['volume_param']) && 'yes' == trim($s_s['volume_param']) ) 
						{
							if ( $_product->get_length() >0 ) {
								$volumnP_l = JooviiCouriersplease_getDimension($_product->get_length(), $pickupCountry);
							} else {
								$volumnP_l = 0;
							}
							if ( $_product->get_width() >0 ) {
								$volumnP_w = JooviiCouriersplease_getDimension($_product->get_width(), $pickupCountry);
							} else {
								$volumnP_w = 0;
							}
							if ( $_product->get_height() >0 ) {
								$volumnP_h = JooviiCouriersplease_getDimension($_product->get_height(), $pickupCountry);
							} else {
								$volumnP_h = 0;
							}
							$volumeP = ( ( $volumnP_l * $volumnP_w * $volumnP_h ) );
							$volume += ( $volumeP * $values['quantity'] );
							Joovii_couriersplease_log_actions( ' volume-> :: ' . $volume . ' = ' . $volumnP_l . '--' . $volumnP_w . '--' . $volumnP_h );
						}
						
						Joovii_couriersplease_log_actions( ' weightP/maxWeight [3-1] : ' . $weightP . '=' . $maxWeight . '-' . $weight );
						
						if ( $weightP > 0 ) 
						{
							$wt = isset($s_s['warningtext'])?$s_s['warningtext']:'';
							if ( $weightP > $maxWeight ) {
								if ( isset($s_s['warningtext_enable']) && 'yes' == $s_s['warningtext_enable']  ) {
									wc_add_notice(  __( 'Weight Exceeds Max Allowed Weight', 'woocommerce' ) );
								}
								return;
							}
							if ( $volumeP >0 ) {
								if ( $volumeP > $maxVolume ) {
									if ( isset($s_s['warningtext_enable']) && 'yes' == $s_s['warningtext_enable'] ) {
										wc_add_notice(  __( 'Volume Exceeds Max Allowed Volume', 'woocommerce' ) );
									}
									return;
								}
							}
							for ($i=1; $i<=$values['quantity']; $i++ ) {
								$packageArr[] = array('w' => JooviiCouriersplease_getWeight ($_product->get_weight(), $pickupCountry ), 'v' => $volumeP);
							}
						} else {
							if ( isset($s_s['warningtext_enable']) && 'yes' == $s_s['warningtext_enable'] ) {
								wc_add_notice(  __( 'Weight is lesser than 0', 'woocommerce' ) );
							}
							return;
						}
						//--------------------------------------------------------------------
						$weightP = JooviiCouriersplease_getWeight( $_product->get_weight(), $pickupCountry );
						if ( 'kg' == $wpWeightUnit ) {
							$weight = $weightP * 1000;
						} elseif ('lbs' == $wpWeightUnit ) {
							$weight = $weightP * 453.6;
						} else {
							$weight= $weightP * 1000;
						}
						if ( $_product->get_length() >0 ) {
							$volumnP_l = JooviiCouriersplease_getDimension($_product->get_length(), $pickupCountry);
							if ( 'm' ==$wpDimensionUnit ) {
								$l=$volumnP_l*100;
							} elseif ('in' == $wpDimensionUnit ) {
								$l=$volumnP_l*2.54;
							} elseif ( 'ft' == $wpDimensionUnit ) {
								$l=$volumnP_l*30.48;
							} else {
								$l=$volumnP_l*100;
							}
						} else {
							$l=5;
						}
						if ( $_product->get_width() >0 ) {
							$volumnP_w = JooviiCouriersplease_getDimension($_product->get_width(), $pickupCountry);
							if ( 'm' == $wpDimensionUnit ) {
								$w=$volumnP_w*100;
							} elseif ( 'in' == $wpDimensionUnit ) {
								$w=$volumnP_w*2.54;
							} elseif ( 'ft' == $wpDimensionUnit ) {
								$w=$volumnP_w*30.48;
							} else {
								$w=$volumnP_w*100;
							}
						} else {
							$w=5;
						}
						if ( $_product->get_height() >0 ) {
							$volumnP_h = JooviiCouriersplease_getDimension( $_product->get_height(), $pickupCountry );
							if ( 'm' == $wpDimensionUnit ) {
								$h=$volumnP_h*100;
							} elseif ( 'in' == $wpDimensionUnit ) {
								$h=$volumnP_h*2.54;
							} elseif ( 'ft' == $wpDimensionUnit ) {
								$h=$volumnP_h*30.48;
							} else {
								$h=$volumnP_h*100;
							}
						} else {
							$h=5;
						}
						if ( '0' == $_product->get_parent_id() ) {
							$cartChkout['rate']['items'][] = array( 'name' => $_product->get_name(), 'sku' => $_product->get_sku(), 'quantity' => $values['quantity'], 'grams' =>$weight, 'dimension' => array('l' => $l, 'w' =>$w, 'h' =>$h), 'price' => $_product->get_price(), 'vendor' => '', 'requires_shipping' => $_product->get_shipping_class_id(), 'taxable' => $_product->get_tax_status(), 'fulfillment_service' => '', 'properties' => array(), 'product_id' => $_product->get_id(), 'variant_id' => $_product->get_id() );
						} else {
							$cartChkout['rate']['items'][] = array( 'name' => $_product->get_name(), 'sku' => $_product->get_sku(), 'quantity' => $values['quantity'], 'grams' =>$weight, 'dimension' => array('l' => $l,'w' =>$w,'h' =>$h), 'price' => $_product->get_price(), 'vendor' => '', 'requires_shipping' => $_product->get_shipping_class_id(), 'taxable' => $_product->get_tax_status(), 'fulfillment_service' => '', 'properties' => array(), 'product_id' => $_product->get_parent_id(), 'variant_id' => $_product->get_id() );
						}
					}
					
					// foreach ends here 
					
					Joovii_couriersplease_log_actions('cartChkout data Arr 1 : ' . print_r($cartChkout, true) );
					$cartfetch=json_encode($cartChkout);
					Joovii_couriersplease_log_actions('cartChkout data Arr 2 : ' . print_r(['datapick'=>$cartfetch], true) );
					$st = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
					$shop_id = isset($st['shop_id']) ? $st['shop_id'] : '';
					$securitycode = isset($st['accesstoken']) ? $st['accesstoken'] : '';
					$url =   '/getwebapquote?shop=x&shopid=' . $shop_id . '&securitycode=' . $securitycode;
					Joovii_couriersplease_log_actions('Cart/Checkout calling API url to fetch RATES : ' . $url );
					$cartfetch_data = ['datapick'=>$cartfetch];
					$response = JooviiCouriersplease_makeapicall($url, $cartfetch_data);
					Joovii_couriersplease_log_actions('COURIERSPLEASE FETCH RATE :: webapp--response: ' . $response );
					$result = json_decode($response, true);
					$q = 1;
					$result_rate = [];
					Joovii_couriersplease_log_actions(' cartChkout data Arr 3 : ' . print_r($result, true) ); 
/* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */	
	/* $cartfetch='{"rate":{"origin":{"country":"AU","postal_code":"2000","province":"NSW","city":"sydney","name":"Andrew","address1":"123 Edward Street","address2":"123 Edward Street","address3":"123 Edward street","latitude":"","longitude":"","phone":"+61232323232","fax":"+61232323232","email":"andrew","address_type":"pickup","company_name":"andrew"},"destination":{"country":"au","postal_code":"3004","province":"vic","city":"melbourne","name":"fgdfg","address1":"dfdfgdfg","address2":"dfdfgdfg","address3":"dfgdfg","latitude":"","longitude":"","phone":"989898999","fax":"989898999","email":"a@a.com","address_type":"","company_name":""},"items":[{"name":"Ninja yyyy-950-color - Black","sku":"HOODIE-HAPPY-NINJA-1-1","quantity":1,"grams":100,"dimension":{"l":10,"w":2,"h":2},"price":"7","vendor":"","requires_shipping":0,"taxable":"taxable","fulfillment_service":"","properties":[],"product_id":111,"variant_id":227}]}}';
	
	Joovii_couriersplease_log_actions('cartChkout data Arr 2 : ' . print_r(['datapick'=>$cartfetch], true) );
				$st = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
				$shop_id = isset($st['shop_id']) ? $st['shop_id'] : '';
				$securitycode = isset($st['accesstoken']) ? $st['accesstoken'] : '';
				$url =   '/getwebapquote?shop=x&shopid=' . $shop_id . '&securitycode=' . $securitycode;
				Joovii_couriersplease_log_actions('Cart/Checkout calling API url to fetch RATES : ' . $url );
				$cartfetch_data = ['datapick'=>$cartfetch];
				$response = JooviiCouriersplease_makeapicall($url, $cartfetch_data);
				Joovii_couriersplease_log_actions('COURIERSPLEASE FETCH RATE :: webapp--response: ' . $response );
				$result = json_decode($response, true);
				$q = 1;
				$result_rate = [];
				Joovii_couriersplease_log_actions(' cartChkout data Arr 3 : ' . print_r($result, true) ); */
	
	/* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */				
					if ( isset($result['rates']) ) 
					{
						Joovii_couriersplease_log_actions('Adding Rates to Cart');
						$counter = 1;
						foreach ( $result['rates'] as $value )
						{
							$result_rate = [];
							$result_rate[0]['quote']['gross']['amount'] = ( $value['total_price']/100 );
							$result_rate[0]['quote']['net']['amount'] = ( $value['net_price']/100 );
							$result_rate[0]['quote']['tax']['amount'] = ( isset($value['tax_price']) ? $value['tax_price']/100  : 0 ) ;
							$result_rate[0]['plan_name'] = $value['service_name'];

							$rate = JooviiCouriersplease_createRateArray ($package, $s_s, $result_rate, $counter++ );

							Joovii_couriersplease_log_actions('GOT this from JooviiCouriersplease_createRateArray ' . print_r($rate, true) );

							$this->add_rate($rate);
							$q++;
						} 
					}

			}
		}
	}
}


function Joovii_couriersplease_getcityziplookup () {
  $input =  ( isset ($_REQUEST['q']) ? sanitize_text_field($_REQUEST['q']) : '' );
  $inputArr = explode('countrycode', $input);
  $placename_startsWith = $inputArr[0];
  $country=$inputArr[1];
	if(strlen($country)>2){
		$cc =WC()->countries->countries;
		foreach ($cc as $cc_key => $cc_value) {
			if($cc_value == $country){
				$country = $cc_key;
			}
		}
	}


  $url = 'http://api.geonames.org/postalCodeSearchJSON?placename_startsWith=' . $placename_startsWith . '&maxRows=400&country=' . $country . '&username=nerdster';
  $url = str_replace(' ', '%20', $url);
  
  $suggestions1 = wp_remote_get($url);
  $respFromLookup = wp_remote_retrieve_body($suggestions1);
  
  Joovii_couriersplease_log_actions("COURIERSPLEASE CITYZIP Lookup :: $url ==> Response :: $respFromLookup");
  
  $suggestions2 = json_decode($respFromLookup, true);
  
	$json = '';
	foreach ( $suggestions2['postalCodes'] as $k => $v ) {
		$json .= '{"ID":' . ( $k + 1 ) . ',"label":"' . $v['placeName'] . ', ' . $v['postalCode'] . ' ' . $v['adminName1'] . ' ' . $country . '","city":"' . $v['placeName'] . '","zip":"';
		$json .=  $v['postalCode'] . '","statecode":"' . trim( $v['ISO3166-2'] ) . '","statename":"' . trim($v['adminName1']) . '"},';
	}
	$json = rtrim($json, ',');
	$json = '[' . $json . ']';
	echo  ( $json );
	die();
}
