<?php
/**
* Plugin Name: Joovii Couriersplease Shipping
* Plugin URI: https://joovii.com/woocommerce-plugin/wordpress-couriersplease-premium-plugin/
* Description: This app provides the ultimate connectivity between Woocommerce and Couriersplease.
* Version: 1.0.1
* Author: Joovii
* Author URI: http://joovii.com/installation-instruction/wp
* License: GPL-3.0+
* License URI: http://www.gnu.org/licenses/gpl-3.0.html
* Domain Path: /lang
* Text Domain: Joovii
* WC requires at least: 6.5.5
* WC tested up to: 9.0.2
*/

$plugin_path = trailingslashit( WP_PLUGIN_DIR ) . 'woocommerce/woocommerce.php';

define( 'J_COURIERSPLEASE_JOOVII_AU_MAX_DOMESTIC_WEIGHT', '25' );
define( 'J_COURIERSPLEASE_JOOVII_AU_MAX_INTERNATIONAL_WEIGHT', '20' );
define( 'J_COURIERSPLEASE_JOOVII_US_MAX_DOMESTIC_WEIGHT', '70' );
define( 'J_COURIERSPLEASE_JOOVII_CA_MAX_DOMESTIC_WEIGHT', '25' );
define( 'J_COURIERSPLEASE_JOOVII_AU_MAX_DOMESTIC_VOLUME', '0.100001' );
define( 'J_COURIERSPLEASE_JOOVII_AU_MAX_INTERNATIONAL_VOLUME', '0.125' );
define( 'J_COURIERSPLEASE_JOOVII_US_MAX_DOMESTIC_VOLUME', '864' );
define( 'J_COURIERSPLEASE_JOOVII_CS_MAX_DOMESTIC_VOLUM', '0.125' );
define( 'J_COURIERSPLEASE_JOOVII_WP_PLUGIN_VERSION', '1.0.1' );
define('J_COURIERSPLEASE_JOOVII_WEBAPP_URL', 'https://webapp.joovii.com');

$plugin_arr = [];

if( is_multisite() )
{
    $plugin_arr = wp_get_active_network_plugins() ;
}
else
{
	$plugin_arr = wp_get_active_and_valid_plugins();
}

if (in_array( $plugin_path, $plugin_arr ))
{

	$countries = ['CA' => 'Canada', 'AU' => 'Australia', 'US' => 'United States', 'NZ' => 'New Zealand'];

	add_action( 'before_woocommerce_init', function() {
		if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	} );

	add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'JooviiCouriersplease_add_plugin_page_settings_link');
	add_action( 'woocommerce_shipping_init', 'JooviiCouriersplease_Shipping_Method' );
	add_filter( 'woocommerce_shipping_methods', 'JooviiCouriersplease_add_shipping_method' );

	add_action('admin_menu', 'Joovii_couriersplease_admin_menu_settings');
	add_action('admin_menu', 'Joovii_couriersplease_trackingemailtemplate_menu');
	add_action('admin_menu', 'Joovii_couriersplease_export_order_in_bulk_menu');

	require_once('joovii-couriersplease-shipping-function.php');
	require_once('joovii-couriersplease-shipping-zone.php');
	require_once('joovii-couriersplease-loader.php');
	require_once('joovii-couriersplease-logs.php');
	require_once('joovii-couriersplease-admin-feature.php');
	require_once('joovii-couriersplease-tracking-email.php');
	require_once('joovii-couriersplease-order-bulk-export.php');
	require_once('joovii-couriersplease-order-export-hooks.php');
	require_once('joovii-couriersplease-order-shipment-update-hooks.php');

	$joovii_couriersplease_setting = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );

	add_action('woocommerce_thankyou', 'JooviiCouriersplease_generate_reference', 111, 1);

}

function joovii_couriersplease_check_if_hpos_enabled()
{
	$hpos_enabled = 0;

	if (class_exists(\Automattic\WooCommerce\Utilities\OrderUtil::class) ) {
		if (\Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled() ) {
			$hpos_enabled  = 1;
		}
	}

	return $hpos_enabled;
}

function JooviiCouriersplease_generate_reference($order_id=0, $postedby='byfn') {

	$joovii_couriersplease_setting = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
	$book_shipment_on = isset($joovii_couriersplease_setting['book_shipment_on']) ? $joovii_couriersplease_setting['book_shipment_on'] : '';
	Joovii_couriersplease_log_actions('----------- ' . $book_shipment_on . '------- ' . $postedby . '------- ' . $order_id . '------------------------/n');
	Joovii_couriersplease_log_actions('joovii_couriersplease_setting array :: ' . print_r($joovii_couriersplease_setting, true) );

	$putarray = ['orderid'=>$order_id, 'shopid'=>$joovii_couriersplease_setting['shop_id'], 'securitycode'=>$joovii_couriersplease_setting['accesstoken'], 'order_onsubmit'=>'yes', 'bookshipment'=>'yes'];
	$securitycode = isset($st['accesstoken']) ? $st['accesstoken'] : '';

	$str =  'Before Save-order:: ' . J_COURIERSPLEASE_JOOVII_WEBAPP_URL .
	        '/shopadmin/woocom/sync/order/update?orderid=' . $order_id  . "\n" .
			'POST ARRAY :: ' . print_r( $putarray , true) . "\n" ;

	$ret = JooviiCouriersplease_makeapicall( '/shopadmin/woocom/sync/order/update?orderid=' . $order_id, $putarray ) ;

	$str .= 'After Save-order:: ' . print_r($ret, true) ;

	Joovii_couriersplease_log_actions('JooviiCouriersplease_generate_reference :: ' . $str );

}


// Separate SYNC during Plugin Activation Function
function JooviiCouriersplease_webapp_sync_store_standalone() {

	global $wp_version;


	Joovii_couriersplease_log_actions('Sync during activation :: Started');

	$all_options = wp_load_alloptions();

	// FETCH OLD PLUGIN Settings
	$allopt = [];
	if( isset($all_options['woocommerce_ossmcouriersplease_settings']) && $all_options['woocommerce_ossmcouriersplease_settings'] != '' )
	{
	  $allopt = maybe_unserialize($all_options['woocommerce_ossmcouriersplease_settings']);
	}

	// below variable will hold all new VALUES to be saved
	$set = [];

	$st = $allopt;
	$id = '';
	$key = '';
	$mode = '';
	if ( is_array($st) ) {
		if (isset($st['api_id']) && '' != trim($st['api_id']) && isset($st['api_key']) && '' != trim($st['api_key'])  && isset($st['mode']) && '' != trim($st['mode'])) {
			$id = $st['api_id'];
			$key = $st['api_key'];
			$mode = $st['mode'];
		}
	}

	$id = $id == '' ? '' : $id;
	$key = $key == '' ? '' : $key;

	$set = ['api_id' => $id, 'api_key' => $key, 'mode' => $mode];

	if ( 1 )
	{
		$set['site_url'] = get_option('siteurl');
		$set['id'] = uniqid();
		$set['name'] = get_option('blogname');
		$set['email'] = get_option('admin_email');
		$set['domain'] = ( isset ($_SERVER['REMOTE_ADDR']) ? sanitize_text_field($_SERVER['REMOTE_ADDR']) : '' );
		$d = get_option('woocommerce_default_country');
		$province = $d;
		$country  = $d;
		if ( '' != $d) {
			$t = explode(':', $d);
			if (count($t) == 2) {
				$country  = $t[0];
				$province = $t[1];
			}
		}
		$set['province']  = $province;
		$set['country']   = $country;

		$address1 = isset($allopt['sender_address']) && $allopt['sender_address']!= '' ? $allopt['sender_address'] : trim(get_option('woocommerce_store_address'));
		$set['address1']  = $address1;

		$set['address2']  = trim(get_option('woocommerce_store_address_2'));

		// ZIP
		$set['zip']       = isset($allopt['zip']) && $allopt['zip']!= '' ? $allopt['zip'] : get_option('woocommerce_store_postcode');
		if(trim($set['zip']) == '')
		{
			$set['zip'] = isset($allopt['pickup_postcode']) ? $allopt['pickup_postcode'] : '';
		}

		// CITY
		$set['city']      = isset($allopt['city']) && $allopt['city']!= '' ? $allopt['city'] : get_option('woocommerce_store_city');
		if(trim($set['city']) == '')
		{
			$set['city'] = isset($allopt['pickup_suburb']) ? $allopt['pickup_suburb'] : '';
		}


		$set['source']    = '';

		// GET PHONE
		$current_user = get_currentuserinfo();
		$phone = isset($allopt['sender_contact_number']) ? $allopt['sender_contact_number'] : '';
		if($phone == '')
		{
		  $phone = get_user_meta($current_user->ID,'user_phone',true);
		}
		$set['phone']     = $phone;
		$set['latitude']  = '';
		$set['longitude'] = '';
		$set['primary_locale'] = 'en';
		//$set['created_at']   = '';
		//$set['updated_at']   = '';
		$set['country_code'] = $country;
		$set['country_name'] = get_option('woocommerce_default_country');
		$set['currency']     = get_option('woocommerce_currency');
		$set['customer_email'] = get_option('admin_email');
		$set['timezone'] = '';
		$set['iana_timezone'] = '';
		$set['shop_owner']   = '';
		$admin_user = get_user_by( 'email', $set['email']);

		if ( !isset($allopt['sender_name']) || '' == $allopt['sender_name']) {
			if ( $admin_user ) {
				$first_name = get_user_meta($admin_user->ID, 'first_name', true);
				$last_name  = get_user_meta($admin_user->ID, 'last_name', true);
				if ( '' == $first_name . $last_name) {
					$set['shop_owner'] = get_option('blogname');
				} else {
					$set['shop_owner'] = $first_name . ' ' . $last_name;
				}
			}
		} else {
			$set['shop_owner'] = isset($allopt['sender_name']) ? $allopt['sender_name'] : '';
		}
		$set['money_format'] = $set['currency'] . '{{amount}}';
		$set['money_with_currency_format']='${{amount}} ' . $set['currency'];
		$set['weight_unit'] = get_option('woocommerce_weight_unit');
		$set['dimension_unit'] = get_option('woocommerce_dimension_unit');
		$set['province_code'] = $province;
		$set['taxes_included']='';
		$set['auto_configure_tax_inclusivity']='';
		$set['tax_shipping']='';
		$set['county_taxes'] = '1';
		$set['plan_display_name'] = '';
		$set['plan_name']  = '';
		$set['has_discounts']='';
		$set['has_gift_cards']='';
		$set['myshopify_domain']='';
		$set['google_apps_domain']='';
		$set['google_apps_login_enabled']='';
		$set['money_in_emails_format']= $set['currency'] . '{{amount}}';
		$set['money_with_currency_in_emails_format']='${{amount}} ' . $set['currency'];
		$set['eligible_for_payments'] = '1';
		$set['requires_extra_payments_agreement']='';
		$set['password_enabled']='';
		$set['has_storefront']='';
		$set['finances']='1';
		$set['primary_location_id']='';
		$set['checkout_api_supported']='';
		$set['multi_location_enabled']='';
		$set['setup_required']='';
		$set['pre_launch_enabled']='';
		$set['transactional_sms_disabled']='';
		$set['marketing_sms_consent_enabled_at_checkout']='';
		$set['pickup_country'] = get_option('woocommerce_joovii_couriersplease_pickup_country');

		// New ADDITION
		$set['pickup_suburb'] = isset($allopt['pickup_suburb']) ? $allopt['pickup_suburb'] : '';
		$set['pickup_postcode'] =  isset($allopt['pickup_postcode']) ? $allopt['pickup_postcode'] : '';
		$set['pickup_country']  =  isset($allopt['pickup_country']) ? $allopt['pickup_country'] : '';
		$set['enable_addressmatch'] = isset($allopt['enable_addressmatch']) ? $allopt['enable_addressmatch'] : '';
		$set['volume_param']    = isset($allopt['volume_param']) ? $allopt['volume_param'] : '';
		$set['warningtext_enable'] = isset($allopt['warningtext_enable'])?$allopt['warningtext_enable']:'';
		$set['warningtext']     = isset($allopt['warningtext'])?$allopt['warningtext']:'';
		$set['pickupoption'] = isset($allopt['pickupoption']) ? $allopt['pickupoption'] : '';
		$set['book_shipment_on']= isset($allopt['book_shipment_on']) ? $allopt['book_shipment_on'] : '';
		$set['sender_name'] = isset($allopt['sender_name']) ? $allopt['sender_name'] : '';
		$set['sender_contact_number'] = isset($allopt['sender_contact_number']) ? $allopt['sender_contact_number'] : '';
		$set['sender_address'] = trim($set['address1'] . ' ' . $set['address2']);
		$set['sender_state'] = isset($allopt['sender_state']) ? $allopt['sender_state'] : '';
		$set['sender_instruction']=isset($allopt['sender_instruction']) ? $allopt['sender_instruction'] : '';
		$set['receiver_instruction'] = isset($allopt['receiver_instruction']) ? $allopt['receiver_instruction'] : '';
		$set['pickup_delay'] = isset($allopt['pickup_delay']) ? $allopt['pickup_delay'] : '';
		$set['change_order_status'] = isset($allopt['change_order_status']) ? $allopt['change_order_status'] : '';
		$set['tracking_email']=isset($allopt['tracking_email']) ? $allopt['tracking_email'] : '';
		$set['hs_code'] = isset($allopt['hs_code']) ? $allopt['hs_code'] : '';
		$set['hs_code_field_name'] = isset($allopt['hs_code_field_name']) ? $allopt['hs_code_field_name'] : '';
		$set['optintojoovii']=isset($allopt['optintojoovii']) ? $allopt['optintojoovii'] : '';
		$set['contents_type'] = isset($allopt['contents_type']) ? $allopt['contents_type'] : '';
		$set['enable_log']=isset($allopt['enable_log']) ? $allopt['enable_log'] : 'No';
		$set['packaging_weight_cart'] = isset($allopt['packaging_weight_cart']) ? $allopt['packaging_weight_cart'] : '';
		$set['hide_pickup_address'] = isset($allopt['hide_pickup_address']) ? $allopt['hide_pickup_address'] : '';
		$set['quote_markup'] = isset($allopt['quote_markup']) ? $allopt['quote_markup'] : '';
		$set['shipping_handling_fee'] = isset($allopt['shipping_handling_fee']) ? $allopt['shipping_handling_fee'] : '';

		// VErsions
		$set['wp_version'] = $wp_version;
		$set['wc_version'] = '0.0.0';

		if( class_exists('woocommerce') && function_exists('get_plugin_data') && file_exists('../wp-content/plugins/woocommerce/woocommerce.php') )
		{
		   $plugin_data = get_plugin_data( '../wp-content/plugins/woocommerce/woocommerce.php', false );

		   if( is_array($plugin_data) && isset($plugin_data['Version']) )
		   {
			  $set['wc_version'] = $plugin_data['Version'];
		   }
		}

		$set['plugin_version'] = '1.1.6';


		Joovii_couriersplease_log_actions('Before Save-Settings CALL :: ' . print_r($set, true) );
		$ret = JooviiCouriersplease_makeapicall('/woocom/couriersplease/sync/store/savesettings', $set) ;
		Joovii_couriersplease_log_actions('After Save-Settings CALL :: ' . print_r($ret, true) );
		$temp = json_decode($ret, true);

		if ( is_array($temp) ) {
			if ( isset($temp['shop_id']) && '' != $temp['shop_id'] && isset($temp['accesstoken']) && '' != $temp['accesstoken']	) {
				$data = ['enabled' => 'yes', 'showrates' => 'yes'];
				if ( isset($temp['shop_id']) && '' != $temp['shop_id'] ) {
					$data['shop_id'] = $temp['shop_id'];
				}

				if ( isset($temp['accesstoken']) && '' != $temp['accesstoken'] ) {
					$data['accesstoken'] = $temp['accesstoken'];
				}

				if ( count($data) ) {
					// UPDATE Options
					foreach ($data as $key => $val) {
						if ( '' != $key) {
							if ( 'accesstoken' == $key  ||  'shop_id' == $key ) {
								$st[$key] = $val;
							}
						}
					}

					// MERGE $set and $st
					$final = array_merge($st, $set);
					Joovii_couriersplease_log_actions('Standalone :: Updated shopid and accesstoken in Settings');
					update_option('woocommerce_jooviicouriersplease_settings', $final);
				}
			}
			add_action('admin_notices', function() use ( $temp ) {
				if ( is_array($temp) ) {
					if ( isset($temp['err']) && isset($temp['msg']) ) {
						$class = $temp['err'] ? 'error' : 'updated';
						echo "<div class='case1 notice $class'><p>" . esc_html($temp['msg']) . "</p></div>";
					}
				}
			});
		} else {
			add_action('admin_notices', function() use ( $temp ) {
				echo "<div class='case3 notice error'><p>Error 3 : Credential Validation Failed.</p></div>";
			} );
		}
	} else {
		Joovii_couriersplease_log_actions('SaveSettings Error .. Params Missing');
	}
}


// CREATE WebHook, for Updating Order at WebApp End
function JooviiCouriersplease_webhook_create()
{

	global $wpdb, $table_prefix;

	// Initially Check if WEBHOOK already exists
	// $sql = "Select count(*) as cnt from " . $table_prefix . "wc_webhooks where name = 'JooviiOrderCreated'; ";
	// $results = $wpdb->get_results( $sql );
	// $cnt = $results[0]->cnt;

	// 17th July 2024
	// WE dont create WEBHOOK. WE DISABLE existing WEBHOOk
	// $sql = "UPDATE " . $table_prefix . "wc_webhooks SET status='disabled' where name = 'JooviiOrderCreated'; ";
	// $wpdb->get_results( $sql );

	// EXTRACT Settings for SHOPID etc
	$joovii_couriersplease_setting = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
	$shopid       = isset($joovii_couriersplease_setting['shop_id']) ? $joovii_couriersplease_setting['shop_id'] : '' ;
	$securitycode = isset($joovii_couriersplease_setting['accesstoken']) ? $joovii_couriersplease_setting['accesstoken'] : '' ;


	/*
	// CREATE WebHOOK
	if( $cnt == 0 && $shopid != '' && $securitycode != '')
	{
		// CREATE WEBBHOOK for SYNC ORDERs :: Starts
		$userID = '1';
		$topic = 'order.created';
		$userName = 'JooviiOrderCreated';
		$secret = wp_generate_password(50, true, true);

		$deliveryURL = J_COURIERSPLEASE_JOOVII_WEBAPP_URL . '/shopadmin/woocom/sync/order/webhookcall?callname=jooviiordercreated&shopid=' .
					   $shopid . '&securitycode=' . $securitycode;

		$status  = 'active';
		$webhook = new WC_Webhook();
		$webhook->set_user_id($userID); // User ID used while generating the webhook payload.
		$webhook->set_name($userName);
		$webhook->set_topic($topic); // Event used to trigger a webhook.
		$webhook->set_secret($secret); // Secret to validate webhook when received.
		$webhook->set_delivery_url($deliveryURL); // URL where webhook should be sent.
		$webhook->set_status($status); // Webhook status.
		$save = $webhook->save();
		// CREATE WEBBHOOK for SYNC ORDERs :: Ends

		Joovii_couriersplease_log_actions('JooviiCouriersplease :: WebHook Created for SHOP ID ' . $shopid);

	}
	*/

}

/**
* This function creates webhook for order created and updated.
*
* @internal
*
* @return object
*/
function JooviiCouriersplease_webhook_plugin_activated() {

	global $wpdb, $table_prefix;

    Joovii_couriersplease_log_actions('JooviiCouriersplease_webhook_plugin_activated function CALLed');

	// BUILD new ZONE settings
	// STEP 1 : CHECK of ZONE settings were there in the OLD plugin
	$sql = "SELECT * from " . $table_prefix . "woocommerce_shipping_zone_methods WHERE method_id = 'ossmcouriersplease-zone'";
	$oldzoneresults = $wpdb->get_results($sql);
	//Joovii_couriersplease_log_actions('Activation : Zone Settings Step 1 : found ' .$wpdb->num_rows );
	if( $wpdb->num_rows >= 0 )
	{

		$all_options = wp_load_alloptions();
		if( isset($all_options['woocommerce_ossmcouriersplease_settings']) && $all_options['woocommerce_ossmcouriersplease_settings'] != '' )
		{
		  $old_plugin_settings = maybe_unserialize($all_options['woocommerce_ossmcouriersplease_settings']);

		  // FETCH 2 settings from OLD PLUGIN
		  // and BUILD new SETTINGs
		  $final_arr = ['quote_markup' => 0, 'shipping_handling_fee' => 0] ;

		  if(isset($old_plugin_settings['quote_markup']) && $old_plugin_settings['quote_markup'] != '')
		  {
			 $final_arr['quote_markup'] = $old_plugin_settings['quote_markup'];
		  }
		  if(isset($old_plugin_settings['shipping_handling_fee']) && $old_plugin_settings['shipping_handling_fee'] != '')
		  {
			 $final_arr['shipping_handling_fee'] = $old_plugin_settings['shipping_handling_fee'];
		  }

		  //Joovii_couriersplease_log_actions('Activation : Zone Settings STEP 2 : ' . print_r($final_arr, true) );

		  $updated = 0;

		  foreach($oldzoneresults as $zone)
		  {
			 $instance = $zone->instance_id;
			 $key = "woocommerce_joovii-couriersplease-zone_". $instance . "_settings";

			 // CREATE NEW SETTINGs
			 update_option($key, serialize($final_arr));
			 $updated++;
		  }

		  //Joovii_couriersplease_log_actions('Activation : Zone Settings STEP 3 : ' . $updated );

		}
	}

	// UPDATE SHIPPING ZONEs, replace OLD shipping method with new Shipping method name
	$sql = "UPDATE " . $table_prefix . "woocommerce_shipping_zone_methods SET method_id = 'joovii-couriersplease-zone' where method_id='ossmcouriersplease-zone' ";
	$wpdb->get_results($sql);

	// DEACTIVATE OLD PLUGIN
	deactivate_plugins( ['official-couriersplease-shipping-method/joovii-couriersplease-shipping.php'], true );

	// SYNC	the STORE with WebAPP with default Settings.
	JooviiCouriersplease_webapp_sync_store_standalone();

	// CREATE WebHook
	JooviiCouriersplease_webhook_create();

	return 1;

}

register_activation_hook(__FILE__, 'JooviiCouriersplease_create_logs_table');
register_activation_hook(__FILE__, 'JooviiCouriersplease_webhook_plugin_activated');

/**
* This function creates a new table to store log data.
*
* @internal
*
* @return boolean
*/
function JooviiCouriersplease_create_logs_table() {
	global $wpdb;
	$table_name = $wpdb->prefix . 'joovii_courierspleaselogs';
	$charset_collate = $wpdb->get_charset_collate();
	$sql = "CREATE TABLE IF NOT EXISTS $table_name (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`eventname` varchar(50) CHARACTER SET utf8 NOT NULL,
		`orderid` int(11) NOT NULL,
		`logs` text CHARACTER SET utf8 NOT NULL,
		`timestamp` varchar(50) CHARACTER SET utf8 NOT NULL,
		PRIMARY KEY (`id`)
	)" . $charset_collate . '; ';
	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta($sql);
	return true;
}

/**
* This function adds "Couriersplease Settings" submenu in left Main Menu .
*
* @internal
*
* @return boolean
*/

function Joovii_couriersplease_admin_menu_settings() {


	add_submenu_page( 'woocommerce', 'Joovii Couriersplease Settings', 'Joovii Couriersplease Settings', Joovii_couriersplease_getAssignRole(), 'admin.php?page=wc-settings&tab=shipping&section=jooviicouriersplease', null, 2 );


	return true;
}

/**
* This function adds "COURIERSPLEASE Email Template" submenu in leftmenu.
*
* @internal
*
* @return boolean
*/
function Joovii_couriersplease_trackingemailtemplate_menu() {

	add_submenu_page('admin.php?page=JooviiCouriersplease_trackingemailtemplate', 'Joovii Couriersplease Email Template', 'Joovii Couriersplease Email Template', Joovii_couriersplease_getAssignRole(), 'JooviiCouriersplease_trackingemailtemplate', 'JooviiCouriersplease_trackingemailtemplate', 4 );

	remove_submenu_page('admin.php?page=JooviiCouriersplease_trackingemailtemplate', 'JooviiCouriersplease_trackingemailtemplate');

	return true;
}

/**
* This function creates a new page 'Export Orders'
*
* @internal
*
* @return boolean
*/
function Joovii_couriersplease_export_order_in_bulk_menu() {
	add_submenu_page('admin.php?page=JooviiCouriersplease_export_order_in_bulk',
			'Joovii Couriersplease Order Export',
			'Joovii Couriersplease Order Export',
			Joovii_couriersplease_getAssignRole(),
			'JooviiCouriersplease_export_order_in_bulk',
			'JooviiCouriersplease_export_order_in_bulk', 4 );

	remove_submenu_page('admin.php?page=JooviiCouriersplease_export_order_in_bulk','JooviiCouriersplease_export_order_in_bulk');

	return true;
}

/**
* This function adds "Settings" link in plugin page.
*
* @internal
*
* @return array
*/
function JooviiCouriersplease_add_plugin_page_settings_link( $links ) {
	$links[] = '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=shipping&section=jooviicouriersplease' ) . '">' . __('Settings') . '</a>';
	return $links;
}

add_action('admin_menu', 'JooviiCouriersplease_goto_web_app');

/**
* This function adds "Go To Web App" link in left menu.
*
* @internal
*
* @return array
*/
function JooviiCouriersplease_goto_web_app() {

	add_submenu_page('woocommerce', 'Joovii Couriersplease Shipping App', 'Joovii Couriersplease Shipping App', Joovii_couriersplease_getAssignRole(), 'JooviiCouriersplease_goto_webapp_function', 'JooviiCouriersplease_goto_webapp_function', 3);

	add_submenu_page('admin.php?page=JooviiCouriersplease_goto_subscription_function', 'Joovii Couriersplease Subscription', 'Joovii Couriersplease Subscription', Joovii_couriersplease_getAssignRole(), 'JooviiCouriersplease_goto_subscription_function', 'JooviiCouriersplease_goto_subscription_function', 4);

	remove_submenu_page('admin.php?page=JooviiCouriersplease_goto_subscription_function', 'JooviiCouriersplease_goto_subscription_function');
}

/**
* This function handles when 'Subscribe Now' link is clicked.
*
* @internal
*
* @return void
*/

function JooviiCouriersplease_goto_subscription_function() {

	$_jset = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );

	$subscribeHtml = 'Joovii Couriersplease WooCom Plugin Subscription';


	if( is_array($_jset) && isset($_jset['shop_id']) && $_jset['shop_id']!='' && is_numeric($_jset['shop_id']) &&
		isset($_jset['accesstoken']) && $_jset['accesstoken']!='' )
	{

	   $url = J_COURIERSPLEASE_JOOVII_WEBAPP_URL . '/shopadmin/settings/subscribe?securitycode=' . $_jset['accesstoken']
								   . "&shopid=" . $_jset['shop_id'] . "&product=couriersplease-wp";


       $subscribeHtml = "<iframe src='$url' style='height:1000px;width:100%'></iframe>";
	}

    echo $subscribeHtml;
}

/**
* This function handles when a link is clicked.
*
* @internal
*
* @return void
*/
function JooviiCouriersplease_goto_webapp_function() {

	$st = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );

	$shop_id = isset($st['shop_id']) ? $st['shop_id'] : '';
	$host = get_option('siteurl');
	$securitycode = isset($st['accesstoken']) ? $st['accesstoken'] : '';

	$base_url   = J_COURIERSPLEASE_JOOVII_WEBAPP_URL ;

	$target_url =  $base_url . '/shopadmin/prehomestep?shopid=' . $shop_id . '&securitycode=' . $securitycode ;

	if ( '' == $shop_id || '' == $securitycode ) {
		echo '<span style="font-weight:bold;font-size:15px;">Shop ID or Security Code not found</span>';

	} else {
		/*
		echo '<a id="gotowebapp" href="' . esc_url($target_url) . '" target="_blank">Please Wait</a>
				<script>
				var r = document.getElementById("gotowebapp");
				r.click();

				var timer = setTimeout(function (){
				   r.innerHTML = "Click Here to go back";
				   r.removeAttribute("target");
				   r.setAttribute("onclick", "window.history.go(-1);return false;");
				   r.setAttribute("href", "#");
				   clearTimeout(timer);
				},2000);
				</script>';
		*/

		 echo "<iframe src='". esc_url($target_url) . "' style='width:100%;height:800px;'></iframe>";
	}
}

// Read and Fetch Setting from Database
function joovii_couriersplease_raf($s)
{
	$jss = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );

	if(is_array($jss) && isset($jss[$s]))
	{
		return $jss[$s];
	}

	return '';
}

// GET a proper Settings
function joovii_couriersplease_settingsval($postarr, $setarr, $key, $default = '')
{
	if( isset($postarr[$key]) && $postarr[$key]!='' )
	{
		return $postarr[$key];
	}
	else if( isset($setarr[$key]) && $setarr[$key]!='' )
	{
		return $setarr[$key];
	}
	elseif($default !='')
	{
		return $default;
	}

	return '';
}

/**
* This function creates "Settings" option in  admin for this plugin.
*
* @internal
*
* @return boolean
*/

function JooviiCouriersplease_Shipping_Method() {
	$assign_permission=JooviiCouriersplease_getAssignPermission();
	if ( ! class_exists( 'JooviiCouriersplease_Shipping_Method' )  && $assign_permission ) {
		class JooviiCouriersplease_Shipping_Method extends WC_Shipping_Method {
			/**
			* This is a construct function.
			*
			* @internal
			*
			* @return boolean
			*/
			public function __construct() {

				global $wpdb, $table_prefix, $wp_version;

				$_jset = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );

				$subscribeHtml = '';
				$communicationHTML = '';
				$versionHTML = '';

				if( is_array($_jset) && isset($_jset['shop_id']) && $_jset['shop_id']!='' && is_numeric($_jset['shop_id']) &&
					isset($_jset['accesstoken']) && $_jset['accesstoken']!='' )
				{

					// DISABLE WEBHOOK
					$sql = "UPDATE " . $table_prefix . "wc_webhooks SET status='disabled' where name = 'JooviiOrderCreated'; ";
					$wpdb->get_results( $sql );

	                /// Do CURL call to KNOW the COMMUNICATION STATUS
					$comm_status_msg = 'Communication with Couriersplease Web APP has problem. Various Synchronizations will not work.';
					$comm_status_err = 1;
					$target_url = J_COURIERSPLEASE_JOOVII_WEBAPP_URL . "/checkconnectionstatus?shopid=" . $_jset['shop_id'] . "&securitycode=" . $_jset['accesstoken'] . "&product=couriersplease-wp";

					//echo "calling $target_url";

					$args = [];
					$content = wp_remote_get($target_url);

					if ( is_wp_error( $content ) ) {

						$comm_status_msg = $content->get_error_message();
						$comm_status_err = 1;

						// 🔽 APPEND more technical details (NO logic change)
						$error_data = $content->get_error_data();

						if ( is_array( $error_data ) ) {

							if ( isset( $error_data['curl_errno'] ) ) {
								$comm_status_msg .= ' | cURL errno: ' . $error_data['curl_errno'];
							}

							if ( isset( $error_data['curl_error'] ) ) {
								$comm_status_msg .= ' | cURL error: ' . $error_data['curl_error'];
							}

							if ( isset( $error_data['http_response_code'] ) ) {
								$comm_status_msg .= ' | HTTP code: ' . $error_data['http_response_code'];
							}

							if ( isset( $error_data['url'] ) ) {
								$comm_status_msg .= ' | URL: ' . $error_data['url'];
							}
						}

						// 🔽 Log full raw error data (for deep debugging)
						Joovii_couriersplease_log_actions(
							'COMMUNICATION STATUS ERROR DETAILS: ' . print_r( $error_data, true )
						);
					}
					else
					{

						Joovii_couriersplease_log_actions("COMMUNICATION STATUS [wp_remote_get] [url : $target_url] RECEIVED:" . $content['body']);

						$arr = json_decode( $content['body'], true );

						if( is_array($arr) && isset($arr['error']) && isset($arr['msg']) && $arr['error'] == 0 )
						{
							$comm_status_msg = ''; // IF communication is OKAY, we dont set any SUCCESS message
							$comm_status_err = 0;
						}

					}

					/// Show MESSAGE only IF communication is a problem
					if( $comm_status_err )
					{
						$communicationHTML = "<div class='jooviicourierspleasesubscriptionblock' style='font-weight:bold;color:white;margin-top:10px;background:" .
					   ( $comm_status_err ? '#bd7d7d' : '#585') . "'>$comm_status_msg</div>";

					}

					// SHOW VERSION details only if there is an Upgrade
					$versionHTML = '';

					/// Do CURL call to KNOW the Subscription STATUS
					$is_subscribed = 0;
					$subscription_expired = 1;
					$version_info = "";
					$subscription_id_text = "";

					$target_url = J_COURIERSPLEASE_JOOVII_WEBAPP_URL . "/shopadmin/settings/subscriptionstatus?shopid=" . $_jset['shop_id'] . "&securitycode=" . $_jset['accesstoken'] . "&product=couriersplease-wp&currentversion=" . J_COURIERSPLEASE_JOOVII_WP_PLUGIN_VERSION;
					$args = [];
					$content = wp_remote_get($target_url);

					Joovii_couriersplease_log_actions('Fetching INFO [wp_remote_get] : ' . $target_url);

					if ( is_wp_error( $content ) ) {
						$error_message = $content->get_error_message();
						Joovii_couriersplease_log_actions('Something went wrong while fetching Subscription Status [wp_remote_post]:' . $error_message);
					}
					else
					{
						Joovii_couriersplease_log_actions('[wp_remote_get Couriersplease]:' . $content['body'] );

						if(is_array($content) && isset($content['body']) && $content['body']!='')
						{

							$res = json_decode($content['body'], true);

							if(isset($res['is_subscribed']) && $res['is_subscribed'] == 1) {

								$is_subscribed = 1;

								if(isset($res['subscription']['subscribe_expiry_date'])) {
									$expiry_date = $res['subscription']['subscribe_expiry_date'];
									$today = gmdate("Y-m-d", time());
									if( $expiry_date >= $today )
									{
										$subscription_expired = 0;
									}
								}

								if( isset( $res['subscription']['subscription_id'] ) )
								{
									$subscription_id_text = $res['subscription']['subscription_id'];
								}

							}

							if(isset($res['versionInfo']) && is_array($res['versionInfo']) )
							{
								$lv = isset($res['versionInfo']['meta_value']) ? $res['versionInfo']['meta_value'] : '';

								if( $lv != '' )
								{
									$versionHTML = "<div class='jooviicourierspleasesubscriptionblock' style='font-weight:bold;color:white;margin-top:10px;>
										Latest Version $lv is available for downloading. Download it <a href='https://webapp.joovii.com/wp-plugin/couriersplease/v1/joovii-couriersplease-shipping-" . $lv . ".zip'>here</a>.";

									if( isset($res['versionInfo']['content']) && $res['versionInfo']['content'] != '' )
									{
										$versionHTML .= "<p style='display:block;margin-top:3px;'>" . $res['versionInfo']['content'] . "</p>";
									}

									$versionHTML .= "</div>";
								}
							}
						}
					}

					Joovii_couriersplease_log_actions ("Subscription Status [$is_subscribed][$subscription_expired]");
					$subscribeHtml = "";

					if( $is_subscribed == 0 || $subscription_expired == 1 )
					{
						/*
						$url = J_COURIERSPLEASE_JOOVII_WEBAPP_URL . '/shopadmin/settings/subscribe?securitycode=' . $_jset['accesstoken']
							   . "&shopid=" . $_jset['shop_id'] . "&product=couriersplease-wp";
						*/

						$url = get_site_url() . "/wp-admin/admin.php?page=JooviiCouriersplease_goto_subscription_function";

						$subscribeHtml = "<div class='jooviicourierspleasesubscriptionblock'>
						Subscribe to get Couriersplease Rates at checkout and book Couriersplease Shipment Quickly from a single Dashboard.
						<a href='$url' title='Click to Subscribe' class='subscribeButton'>Subscribe Now !!!</a>
						</div>";
					}

					if( $is_subscribed == 1 && $subscription_expired == 0 )
					{

						if(strtotime($expiry_date) < time() )
						{
							$subscribeHtml = "<div class='jooviicourierspleasesubscriptionblock'>Your Subscription expired on <b>" . gmdate("d M, Y", strtotime($expiry_date)) . ".
							</b></div>";

						}
						else
						{
							$subscribeHtml = "<div class='jooviicourierspleasesubscriptionblock'>
							You have Subscribed to Joovii Couriersplease WooCommerce Plugin and Your Subscription renews on <b>" . gmdate("d M, Y", strtotime($expiry_date)) . ".</b>" .
							( $subscription_id_text != "" ? "<br/><span style='font-size:12px;'>Your Subscription ID : <b>$subscription_id_text</b></span>" : "" ) .
							"</div>";
						}
					}

				}

				$extraLinks				   = "<div class='jooviicourierspleaseintro' style='margin-top:10px;'>
												<a class='courierspleaseLinks' title='Check your Email Templates'  href='admin.php?page=JooviiCouriersplease_trackingemailtemplate'>Check Email Templates</a> | <a  class='courierspleaseLinks' href='admin.php?page=JooviiCouriersplease_export_order_in_bulk' title='send last 60 days Orders to Joovii Web App'>Bulk Order Export to Joovii Web App</a> | <a class='courierspleaseLinks' title='Check information stored in Log' href='admin.php?page=joovii_couriersplease_logs'>Check Logs</a>
											  </div>";

				$this->id                  = 'jooviicouriersplease';
				$this->method_title        = 'Joovii Couriersplease';
				$this->method_description  = '<div class="jooviicourierspleaseintro">This app provides the ultimate connectivity between WooCommerce and Couriersplease. ' .
											 'By integrating Couriersplease with your woocom store, you get in cart shipping quotes, ' .
											 'order confirmation, booking shipment, download shipping labels and easy tracking ' .
											 'updates.</div>' . $versionHTML . $communicationHTML . $extraLinks . $subscribeHtml;
				$this->availability 	   = 'jooviicouriersplease_wp';
				$this->init();
				$this->enabled = isset( $this->settings['enabled'] ) ? $this->settings['enabled'] : 'no';
				$this->title   = isset( $this->settings['title'] ) ? $this->settings['title'] : 'Joovii Couriersplease';
			}
			/**
			* This is a init function.
			*
			* @internal
			*
			* @return boolean
			*/
			public function init() {
				$this->init_settings();
				$this->init_form_fields();
				add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
				add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'JooviiCouriersplease_webapp_sync_store' ) );
				wp_enqueue_style( 'style', plugins_url('joovii-couriersplease-shipping/extra.css') );
			}
			/**
			* This function generates settings html.
			*
			* @internal
			*
			* @return string
			*/
			public function generate_settings_html( $form_fields = array(), $echo = true ) {
				if ( empty( $form_fields ) ) {
					$form_fields = $this->get_form_fields();
				}
				$html_content = '';
				foreach ( $form_fields as $k => $v ) {
					$type = $this->get_field_type( $v );
					if ( 'JooviiCouriersplease_customplaceholder' == $type ) {
						$html_content .= $this->JooviiCouriersplease_generate_text_html_custom( $k, $v );
					} else {
						if ( method_exists( $this, 'generate_' . $type . '_html' ) ) {
							$html_content .= $this->{'generate_' . $type . '_html'}( $k, $v );
						} else {
							$html_content .= $this->generate_text_html( $k, $v );
						}
					}
				}
				if ( $echo ) {
					return $html_content ; // WPCS: XSS ok.
				} else {
					return $html_content ;
				}
			}
			/**
			* This function generates custom settings html.
			*
			* @internal
			*
			* @return string
			*/
			public function JooviiCouriersplease_generate_text_html_custom ( $key, $data ) {
				$defaults = array();
				$data = wp_parse_args( $data, $defaults );
				$html_content = '<tr valign="top">';
				$html_content .= '<td class="forminp" colspan="2">';
				$html_content .= '<div class="customJCOURIERSPLEASEsectionheader">' . wp_kses_post( $data['title'] ) . '</div>';
				$html_content .= '</td>';
				$html_content .= '</tr>';
				return $html_content;
			}

			/**
			* This function generates  settings .
			*
			* @internal
			*
			* @return string
			*/
			public function init_form_fields() {



				$joovii_couriersplease_setting = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
				$shop_id = isset($joovii_couriersplease_setting['shop_id']) ? $joovii_couriersplease_setting['shop_id'] : '';
				$securitycode = isset($joovii_couriersplease_setting['accesstoken']) ? $joovii_couriersplease_setting['accesstoken'] : '';

				// Pickup Suburb
				$city = joovii_couriersplease_raf('pickup_suburb');
				$city = $city != '' ? $city : get_option('woocommerce_store_city');

				// Pickup Country
				$country = joovii_couriersplease_raf('pickup_country');
				$country = $country != '' ? $country : get_option('woocommerce_default_country');

				// Pickup PostCode
				$postcode = joovii_couriersplease_raf('pickup_postcode');
				$postcode = $postcode != '' ? $postcode : get_option('woocommerce_store_postcode');

				// Sender STate
				$state = joovii_couriersplease_raf('sender_state');
				if ( '' != $country ) {
					$data = explode(':', $country);
					if (is_array($data) && count($data)) {
						$country = $data[0];
						$state   =  ($state !='' ? $state :  ( isset($data[1]) ? $data[1] : '' ) );
					}
				}

				$address1 = trim(get_option('woocommerce_store_address'));
				$address2 = trim(get_option('woocommerce_store_address_2'));

				// Sender Name
				$sender_name = joovii_couriersplease_raf('sender_name') ;

				if( $sender_name == '' )
				{
					$sender_name = get_bloginfo( 'name' );
				}

				$current_user_id = get_current_user_id();

				// Sender Phone
				$sender_phone = '';
				$phone = joovii_couriersplease_raf('sender_contact_number');

				if( '' == $phone )
				{
					$phone = get_user_meta($current_user_id, 'billing_phone', true);

					if ('' == $phone) {
					  $phone = get_user_meta($current_user_id, 'shipping_phone', true);
					}
				}

				$sender_phone = $phone;

				// Sender Address
				$sender_address = joovii_couriersplease_raf('sender_address') != '' ? joovii_couriersplease_raf('sender_address') : trim( $address1 . ' ' . $address2 );

				// ----------------orderconfig_line---------------------------------------------------

				$optionArray = array(

					'basicconfig_line' => array(
					    'class'       =>    'separatorClass',
						'title'       => 	__( 'Basic Store Configuration', 'joovii-couriersplease-shipping' ),
						'type'        => 	'JooviiCouriersplease_customplaceholder',
						'description' => 	__( '[Do it here] ', 'joovii-couriersplease-shipping' )
					),

					'enable_log' => array(
						'title'       => 	__( 'Enable Log', 'joovii-couriersplease-shipping' ),
						'type'        => 	'checkbox',
						'description' => 	__( 'Enable Logging of various events', 'joovii-couriersplease-shipping' ),
						'default'     => 	joovii_couriersplease_raf('enable_log')
					),

					'change_order_status' => array(
						'title'       => 	__( 'Change Order Status', 'joovii-couriersplease-shipping' ),
						'type'        => 	'select',
						'description' => 	__( 'Change Order Status to Processing/Completed after shipment booking', 'joovii-couriersplease-shipping' ),
						'default'     => 	joovii_couriersplease_raf('change_order_status')!='' ? joovii_couriersplease_raf('change_order_status') : 'no',
						'options'     => 	array('processing'=>'Processing', 'completed'=>'Completed', 'no'=>'No'),
					),

					'tracking_email' => array(
						'title'         =>	__('Send Tracking Email', 'joovii-couriersplease-shipping'),
						'type'          =>	'checkbox',
						'description'   =>	__('Send Tracking Email. <a href="admin.php?page=JooviiCouriersplease_trackingemailtemplate">Edit Tracking Email Template.</a> ', 'joovii-couriersplease-shipping'),
						'default'       =>	joovii_couriersplease_raf('tracking_email')!='' ? joovii_couriersplease_raf('tracking_email') : 'no'
					),
					'enable_addressmatch' => array(
						'title'       => 	__( 'Enable Address AutoComplete', 'joovii-couriersplease-shipping' ),
						'type'        => 	'checkbox',
						'description' => 	__( 'Enable Address AutoComplete At Checkout', 'joovii-couriersplease-shipping' ),
						'default'     => 	joovii_couriersplease_raf('enable_addressmatch')
					),

				);
				// ----------------orderconfig_line---------------------------------------------------

				// ----------------orderconfig_line---------------------------------------------------
				$order_manager_seperator_array =   array(
					'orderconfig_line' => array(
						'title'       => 	__( 'Order Synchronization Configuration', 'joovii-couriersplease-shipping' ),
						'type'        => 	'JooviiCouriersplease_customplaceholder',
						'description' => 	__( '[Do it here] ', 'joovii-couriersplease-shipping' )
					)
				) ;

				// $optionArray = array_merge($optionArray, $order_manager_seperator_array);
				$order_manager_array =   array();
				$optionArray = array_merge($optionArray, $order_manager_array);
				// ----------------devconfig_line---------------------------------------------------
				$devconfig_manager_array =   array(
					'devconfig_line' => array(
						'title'       => 	__( 'Developer Configuration', 'joovii-couriersplease-shipping' ),
						'type'        => 	'JooviiCouriersplease_customplaceholder',
						'description' => 	__( '[Do it here] ', 'joovii-couriersplease-shipping' )
					),

					'optintojoovii' => array(
						'title'         =>	__('Allow access to Joovii API\'s.', 'joovii-couriersplease-shipping'),
						'type'          =>	'checkbox',
						'description'   =>	__('This is required to allow live shipping quoting and booking and for <br/>support from Joovii. The plugin will be disabled without this access approved.', 'joovii-couriersplease-shipping'),
						'default'       =>	joovii_couriersplease_raf('optintojoovii')!='' ? joovii_couriersplease_raf('optintojoovii') : 'yes'
					),

					'is_dev_installation' => array(
						'title'       => 	__( 'Want to run DEV/LIVE sites together?', 'joovii-couriersplease-shipping' ),
						'type'        => 	'checkbox',
						'description' => 	__( 'If you want to run DEV/LIVE sites together, Tick this only this is the DEV Website. Maximum 2 Sites can run together with a single subscription ID', 'joovii-couriersplease-shipping' ),
						'default'     => 	joovii_couriersplease_raf('is_dev_installation') ? joovii_couriersplease_raf('is_dev_installation') : 'no'
					),

					'dev_installation_id' => array(
						'title'       => 	__( 'Subscription ID', 'joovii-couriersplease-shipping' ),
						'type'        => 	'text',
						'description' => 	__( 'If you are running DEV/LIVE site pair on a single subscription and this is the DEV website, enter the Subscription ID here', 'joovii-sendle-shipping', 'joovii-couriersplease-shipping' ),
						'default'     => 	joovii_couriersplease_raf('dev_installation_id')
					),

				);

				$optionArray = array_merge($optionArray, $devconfig_manager_array);


				// BUILD ROles ARRAY
				$rolesArr = [];
				$wpRoles = Joovii_couriersplease_get_all_wp_roles() ;
				foreach($wpRoles as $key=>$val)
				{
					if(  !in_array($key,['subscriber', 'customer', 'editor', 'author', 'contributor', 'translator']) )
					{
						$rolesArr[$key] = $key;
					}
				}

				$role_manager_array = [ 'role_manager' => ['title'  => __( 'User Role Manager', 'joovii-couriersplease-shipping' ), 'type' => 'select', 'description' => __( 'Which user role can access this plugin', 'joovii-couriersplease-shipping' ), 'default' => 'None',
				'options' => $rolesArr
				]];

				if (Joovii_couriersplease_getAssignRole() == 'administrator') {
					$optionArray = array_merge($optionArray, $role_manager_array);
				}

				$this->form_fields = $optionArray;

				//echo "<pre>";
				//print_r( Joovii_couriersplease_get_all_wp_roles()  );
			}

			public function calculate_shipping( $package = array() ) {

                //$result = ossm_calculateCourierspleaseRate($package );
                //if(!is_array($result)){ reurn; }else{ $this->add_rate( $result ); }
                //$auspost_setting = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
                //ossm_checkCourierspleaseZone($auspost_setting);
			}

			/**
			* This is a copy function returns existing settings.
			*
			* @internal
			*
			* @return string
			*/
			public function JooviiCouriersplease_get_existing_settings() {
				$st = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
				$id = '';
				$key = '';
				$mode = '';
				if ( is_array($st) ) {
					if (isset($st['api_id']) && '' != trim($st['api_id']) && isset($st['api_key']) && '' != trim($st['api_key'])  && isset($st['mode']) && '' != trim($st['mode'])) {
						$id = $st['api_id'];
						$key = $st['api_key'];
						$mode = $st['mode'];
					}
				}

				$id = $id == '' ? '' : $id;
				$key = $key == '' ? '' : $key;

				return ['api_id' => $id, 'api_key' => $key, 'mode' => $mode];
			}

			/**
			* This is a copy function synchronised settings with webapp data.
			*
			* @internal
			*
			* @return string
			*/
			public function JooviiCouriersplease_webapp_sync_store() {

				$postArr = [];

				if(isset($_POST))
				{
					foreach($_POST as $key => $val)
					{
						if( $key )
						{
							$k = str_replace("woocommerce_jooviicouriersplease_","",$key);
							$postArr[$k] = $val;
						}
					}
				}

				Joovii_couriersplease_log_actions('Sync Started');
				$all_options = wp_load_alloptions();
				$allopt = maybe_unserialize($all_options['woocommerce_jooviicouriersplease_settings']);
				$set = $this->JooviiCouriersplease_get_existing_settings();


				// BASIC SETTINGS
				$set['site_url'] = get_option('siteurl');
				$set['id'] = uniqid();
				$set['name'] = get_option('blogname');
				$set['email'] = get_option('admin_email');
				$set['ecomtype'] = 'woocom_couriersplease';
				$set['domain'] = ( isset ($_SERVER['REMOTE_ADDR']) ? sanitize_text_field($_SERVER['REMOTE_ADDR']) : '' );
				$set['latitude']  = '';
				$set['longitude'] = '';
				$set['primary_locale'] = 'en';


				$set['currency']     = get_option('woocommerce_currency');
				$set['customer_email'] = get_option('admin_email');
				$set['timezone'] = '';
				$set['iana_timezone'] = '';

				// ADDRESS, COUNTRY
				$d = get_option('woocommerce_default_country');
				$province = $d;
				$country  = $d;
				if ( '' != $d) {
					$t = explode(':', $d);
					if (count($t) == 2) {
						$country  = $t[0];
						$province = $t[1];
					}
				}

				$set['country_code'] = $country;
				$set['country_name'] = get_option('woocommerce_default_country');
				$set['province']  = $province;
				$set['country']   = $country;

				$set['address1']  = '';

				if( isset($postArr['sender_address'] ) && $postArr['sender_address']!= '')
				{
					$set['address1']  = $postArr['sender_address'];
				}
				else
				{
					if(isset($allopt['address1']) && $allopt['address1'] != '')
					{
						$set['address1'] = $allopt['address1'];
					}
					else
					{
						$set['address1'] = trim(get_option('woocommerce_store_address'));
					}
				}

				$set['address2']  = trim(get_option('woocommerce_store_address_2'));


				// POST VALUES
				$set['enable_log'] = joovii_couriersplease_settingsval($postArr, $allopt, 'enable_log', 'no');
				$set['api_id'] = joovii_couriersplease_settingsval($postArr, $allopt, 'api_id', $set['api_id']);
				$set['api_key'] = joovii_couriersplease_settingsval($postArr, $allopt, 'api_key', $set['api_key']);
				$set['mode'] = joovii_couriersplease_settingsval($postArr, $allopt, 'mode', 'sandbox');
				$set['enable_addressmatch'] = joovii_couriersplease_settingsval($postArr, $allopt, 'enable_addressmatch', 0);

				$set['sender_name'] = joovii_couriersplease_settingsval($postArr, $allopt, 'sender_name', get_option('blogname'));
				$set['sender_contact_number'] = joovii_couriersplease_settingsval($postArr, $allopt, 'sender_contact_number');
				$set['sender_address'] = joovii_couriersplease_settingsval($postArr, $allopt, 'sender_address', trim($set['address1'] . ' ' . $set['address2']) );
				$set['sender_state'] = joovii_couriersplease_settingsval($postArr, $allopt, 'sender_state', $province );

				$set['pickup_suburb'] = joovii_couriersplease_settingsval($postArr, $allopt, 'pickup_suburb', $province );
				$set['pickup_postcode'] =  joovii_couriersplease_settingsval($postArr, $allopt, 'pickup_postcode' );
				$set['pickup_country']  =  joovii_couriersplease_settingsval($postArr, $allopt, 'pickup_country', $country );

				$set['packaging_weight_cart'] = joovii_couriersplease_settingsval($postArr, $allopt, 'packaging_weight_cart' );
				$set['quote_markup'] = joovii_couriersplease_settingsval($postArr, $allopt, 'quote_markup' );
				$set['shipping_handling_fee'] = joovii_couriersplease_settingsval($postArr, $allopt, 'shipping_handling_fee' );
				$set['volume_param']    = joovii_couriersplease_settingsval($postArr, $allopt, 'volume_param' );
				$set['warningtext_enable']  = joovii_couriersplease_settingsval($postArr, $allopt, 'warningtext_enable' );
				$set['warningtext']      = joovii_couriersplease_settingsval($postArr, $allopt, 'warningtext' );
				$set['pickupoption'] = joovii_couriersplease_settingsval($postArr, $allopt, 'pickupoption' );

				//$set['process_as_couriersplease_order'] = joovii_couriersplease_settingsval($postArr, $allopt, 'process_as_couriersplease_order');

				$set['book_shipment_on'] = joovii_couriersplease_settingsval($postArr, $allopt, 'book_shipment_on');
				$set['sender_instruction'] = joovii_couriersplease_settingsval($postArr, $allopt, 'sender_instruction');
				$set['receiver_instruction'] = joovii_couriersplease_settingsval($postArr, $allopt, 'receiver_instruction');
				$set['pickup_delay'] = joovii_couriersplease_settingsval($postArr, $allopt, 'pickup_delay');
				$set['change_order_status'] = joovii_couriersplease_settingsval($postArr, $allopt, 'change_order_status');
				$set['tracking_email'] = joovii_couriersplease_settingsval($postArr, $allopt, 'tracking_email');
				$set['hs_code'] = joovii_couriersplease_settingsval($postArr, $allopt, 'hs_code');
				$set['hs_code_field_name'] = joovii_couriersplease_settingsval($postArr, $allopt, 'hs_code_field_name');
				$set['contents_type'] = joovii_couriersplease_settingsval($postArr, $allopt, 'contents_type');
				$set['optintojoovii'] = joovii_couriersplease_settingsval($postArr, $allopt, 'optintojoovii');

				$set['is_dev_installation'] = joovii_couriersplease_settingsval($postArr, $allopt, 'is_dev_installation');
				$set['dev_installation_id'] = joovii_couriersplease_settingsval($postArr, $allopt, 'dev_installation_id');


				// ZIP
				$set['zip']       = joovii_couriersplease_settingsval($postArr, $allopt, 'pickup_postcode');

				if(trim($set['zip']) == '')
				{
					$set['zip'] = get_option('woocommerce_store_postcode');
				}

				// CITY
				$set['city']      = get_option('woocommerce_store_city');

				if(trim($set['city']) == '')
				{
					$set['city'] = isset($allopt['pickup_suburb']) ? $allopt['pickup_suburb'] : '';
				}

				$set['source']    = '';

				// GET PHONE
				$current_user = wp_get_current_user();
				$phone = $set['sender_contact_number'];
				if($phone == '')
				{
				  $phone = get_user_meta($current_user->ID,'user_phone',true);
				}
				$set['phone']     = $phone;

				// SHOP OWNER
				$set['shop_owner']   = $set['sender_name'];

				if( $set['shop_owner'] == '')
				{
					$admin_user = get_user_by( 'email', $set['email']);

					if ( $admin_user ) {
						$first_name = get_user_meta($admin_user->ID, 'first_name', true);
						$last_name  = get_user_meta($admin_user->ID, 'last_name', true);
						if ( '' == trim($first_name . ' ' . $last_name) ) {
							$set['shop_owner'] = get_option('blogname');
						} else {
							$set['shop_owner'] = $first_name . ' ' . $last_name;
						}
					}
				}

				$set['money_format'] = $set['currency'] . '{{amount}}';
				$set['money_with_currency_format']='${{amount}} ' . $set['currency'];
				$set['weight_unit'] = get_option('woocommerce_weight_unit');
				$set['dimension_unit'] = get_option('woocommerce_dimension_unit');
				$set['province_code'] = $province;
				$set['taxes_included']='';
				$set['auto_configure_tax_inclusivity']='';
				$set['tax_shipping']='';
				$set['county_taxes'] = '1';
				$set['plan_display_name'] = '';
				$set['plan_name']  = '';
				$set['has_discounts']='';
				$set['has_gift_cards']='';
				$set['myshopify_domain']='';
				$set['google_apps_domain']='';
				$set['google_apps_login_enabled']='';
				$set['money_in_emails_format']= $set['currency'] . '{{amount}}';
				$set['money_with_currency_in_emails_format']='${{amount}} ' . $set['currency'];
				$set['eligible_for_payments'] = '1';
				$set['requires_extra_payments_agreement']='';
				$set['password_enabled']='';
				$set['has_storefront']='';
				$set['finances']='1';
				$set['primary_location_id']='';
				$set['checkout_api_supported']='';
				$set['multi_location_enabled']='';
				$set['setup_required']='';
				$set['pre_launch_enabled']='';
				$set['transactional_sms_disabled']='';
				$set['marketing_sms_consent_enabled_at_checkout']='';
				$set['pickup_country'] = get_option('woocommerce_joovii_couriersplease_pickup_country');

				// VErsions
				global $wp_version;
				$set['wp_version'] = $wp_version;
				$set['wc_version'] = '0.0.0';

				if( class_exists('woocommerce') && function_exists('get_plugin_data') && file_exists('../wp-content/plugins/woocommerce/woocommerce.php') )
				{
				   $plugin_data = get_plugin_data( '../wp-content/plugins/woocommerce/woocommerce.php', false );

				   if( is_array($plugin_data) && isset($plugin_data['Version']) )
				   {
					  $set['wc_version'] = $plugin_data['Version'];
				   }
				}

				$set['plugin_version'] = J_COURIERSPLEASE_JOOVII_WP_PLUGIN_VERSION;

				$set['hide_pickup_address'] = isset($allopt['hide_pickup_address']) ? $allopt['hide_pickup_address'] : 0;

				Joovii_couriersplease_log_actions('Before Save-Settings CALL :: ' . print_r($set, true) );
				$ret = JooviiCouriersplease_makeapicall('/woocom/couriersplease/sync/store/savesettings', $set) ;
				Joovii_couriersplease_log_actions('After Save-Settings CALL :: ' . print_r($ret, true) );
				$temp = json_decode($ret, true);

				if ( is_array($temp) ) {
					if ( isset($temp['shop_id']) && '' != $temp['shop_id'] && isset($temp['accesstoken']) && '' != $temp['accesstoken']	) {
						// SET BASIC settings
						$data = ['enabled' => 'yes', 'showrates' => 'yes'];

						if ( isset($temp['shop_id']) && '' != $temp['shop_id'] ) {
							$data['shop_id'] = $temp['shop_id'];
						}

						if ( isset($temp['accesstoken']) && '' != $temp['accesstoken'] ) {
							$data['accesstoken'] = $temp['accesstoken'];
						}

						if ( count($data) ) {
							$this->update_JooviiCouriersplease_settings($data);
						}
					}
					add_action('admin_notices', function() use ( $temp ) {
						if ( is_array($temp) ) {
							if ( isset($temp['err']) && isset($temp['msg']) ) {
								$class = $temp['err'] ? 'error' : 'updated';
								echo "<div class='case2 notice $class'><p>" . esc_html($temp['msg']) . '</p></div>';
							}
						}
					});
				} else {
					add_action('admin_notices', function() use ( $temp ) {
						echo "<div class='case4 notice error'><p>Error 4 : Credential Validation Failed.</p></div>";
					} );
				}

			}
			/**
			* This is a copy function also adds setting.
			*
			* @internal
			*
			* @return array
			*/
			public function update_JooviiCouriersplease_settings($arr) {
				$st = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );

				if ( is_array($st) ) {
					$st['enabled'] = 'yes';
					$st['showrates'] = 'yes';
					foreach ($arr as $key => $val) {
						if ( '' != $key) {
							if ( 'accesstoken' == $key  ||  'shop_id' == $key ) {
								$st[$key] = $val;
							}
						}
					}
					Joovii_couriersplease_log_actions('Updated shopid and accesstoken in Settings');
					update_option('woocommerce_jooviicouriersplease_settings', $st);
				}
			}
		}
	}
}

/**
* This function adds a Shipping Method.
*
* @internal
*
* @return array
*/

function JooviiCouriersplease_add_shipping_method( $methods ) {
	$methods[] = 'JooviiCouriersplease_Shipping_Method';
	return $methods;
}

/**
* This function is for Logging various Actions.
*
* @internal
*
* @return boolean
*/
function Joovii_couriersplease_log_actions($message) {

	if( $message === null ) return;

	global $wpdb;
	$joovii_couriersplease_setting = maybe_unserialize( get_option('woocommerce_jooviicouriersplease_settings') );
	if ( isset($joovii_couriersplease_setting['enable_log']) && 'yes' == $joovii_couriersplease_setting['enable_log']) {
		if ( false !== strpos( $message, 'wp_order_id' ) ) {
			$strpos=strpos($message, 'wp_order_id');
			$orderid= (float) trim (substr ($message, $strpos + 15, 4));
		} else {
			$orderid = 0;
		}
		$table_name = $wpdb->prefix . 'joovii_courierspleaselogs';
		$date = gmdate('Y-m-d H:i:s');
		$wpdb->insert( $table_name, array('eventname'=>'null', 'orderid'=>$orderid, 'logs'=>$message, 'timestamp'=> $date), array('%s', '%d', '%s'));
	}
}

/**
* This function is for making API call.
*
* @internal
*
* @return mixed
*/
function JooviiCouriersplease_makeapicall($uriPath, $postDataArr) {

	$postDataStr = '';

	$base_url = J_COURIERSPLEASE_JOOVII_WEBAPP_URL;

	if ( is_array($postDataArr) && count($postDataArr) ) {

		foreach ($postDataArr as $key=>$val) {

			if ( gettype($val) == 'string')
			{
				$postDataStr .= "$key=" . rawurlencode(trim($val)) . '&';
			}
		}

		$postDataStr = rtrim($postDataStr, '&');
		$target_url = $base_url . $uriPath;
		$args = ['httpversion' => '1.0','body'=> $postDataStr,'method'=> 'POST',];
		Joovii_couriersplease_log_actions("Posting [$postDataStr] to $target_url");
		$content = wp_remote_post($target_url, $args);
		if ( is_wp_error( $content ) ) {
			$error_message = $content->get_error_message();
			Joovii_couriersplease_log_actions("wp_remote_post ERROR inside JooviiCouriersplease_makeapicall >> " . print_r($content, true));
			return  'Something went wrong [wp_remote_post]:' . $error_message;
		}
		$response  = wp_remote_retrieve_body( $content );
		Joovii_couriersplease_log_actions("Received Response from COURIERSPLEASE :: " . $response);
		return $response;
	} else {
		return ['error' => 1, 'msg' => 'Validation Failed'];
	}
}


// returns all WORDPRESS Roles
function Joovii_couriersplease_get_all_wp_roles() {

	global $wp_roles;

	$roles = null;

	if ($wp_roles && property_exists($wp_roles, 'roles')) {

		$roles = $wp_roles->roles;

	}

	return $roles;
}

/**
* This is a copy function also adds setting.
*
* @internal
*
* @return string
*/

function Joovii_couriersplease_getAssignRole() {

	$c_id = get_current_user_id();
	$assign_role = '';
	$user = new WP_User($c_id);

	if ( $user )
	{
		$u_role =  $user->roles;

		if ( is_array($u_role) && in_array('administrator', $u_role)) {

			$assign_role = 'administrator';

		} else {

			// GET Settings
			$joovii_couriersplease_setting = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));
			$role_manager_settings = isset($joovii_couriersplease_setting['role_manager']) ? $joovii_couriersplease_setting['role_manager'] : '';

			// Search
			if (in_array($role_manager_settings, $u_role)) {
				$assign_role = $role_manager_settings;
			}
		}
	}

	return $assign_role;
}

/**
* This function is for getting ASSIGN permission.
*
* @internal
*
* @return String
*/

function JooviiCouriersplease_getAssignPermission() {

	$c_id = get_current_user_id();
	$assign_permission = '0';
	$user = new WP_User($c_id);

	/*
	if (isset($user->roles[0])) {
		$u_role =  $user->roles[0];
		if ( 'administrator' == $u_role) {
			$assign_permission = '1';
		} else {
			$joovii_couriersplease_setting = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));
			$role_manager_settings = $joovii_couriersplease_setting['role_manager'];
			if ($u_role == $role_manager_settings) {
				$assign_permission = '1';
			}
		}
	}
	*/

	if ( $user )
	{
		$u_role =  $user->roles;

		if ( is_array($u_role) && in_array('administrator', $u_role)) {

			$assign_permission = '1';

		} else {

			// GET Settings
			$joovii_couriersplease_setting = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));
			$role_manager_settings = isset($joovii_couriersplease_setting['role_manager']) ? $joovii_couriersplease_setting['role_manager'] : '';

			// Search
			if (in_array($role_manager_settings, $u_role)) {
				$assign_permission = '1';
			}
		}
	}

	return $assign_permission;
}


add_action('upgrader_process_complete', 'JooviiCouriersplease_plugin_upgrade_completed', 10, 2);

function JooviiCouriersplease_plugin_upgrade_completed($upgrader_object, $hook_extra)
{

	// get current plugin version. ( https://wordpress.stackexchange.com/a/18270/41315 )
    if(!function_exists('get_plugin_data')){
        require_once(ABSPATH . 'wp-admin/includes/plugin.php');
    }
    // https://developer.wordpress.org/reference/functions/get_plugin_data/
    $plugin_data = get_plugin_data(__FILE__);
    $plugin_version = ($plugin_data['Version'] ?? 'unknown.version');
    unset($plugin_data);

	Joovii_couriersplease_log_actions('INSIDE UPGRADE COMPLETE HOOK : STEP 1' );

	if ( is_array($hook_extra) && array_key_exists('action', $hook_extra) && $hook_extra['action'] == 'update') {
		if (array_key_exists('type', $hook_extra) && $hook_extra['type'] == 'plugin') {
			Joovii_couriersplease_log_actions('INSIDE UPGRADE COMPLETE HOOK : STEP 2' );
			// if updated the plugins.
            $this_plugin = plugin_basename(__FILE__);
			$this_plugin_updated = false;
			if (array_key_exists('plugins', $hook_extra)) {
				// if bulk plugin update (in update page)
				foreach ($hook_extra['plugins'] as $each_plugin) {
					if ($each_plugin === $this_plugin) {
						$this_plugin_updated = true;
						break;
					}
				}// endforeach;
				unset($each_plugin);
			} elseif (array_key_exists('plugin', $hook_extra)) {
				// if normal plugin update or via auto update.
				if ($this_plugin === $hook_extra['plugin']) {
					$this_plugin_updated = true;
				}
			}

			if ($this_plugin_updated === true) {
				// if this plugin is just updated.
				Joovii_couriersplease_log_actions('INSIDE UPGRADE COMPLETE HOOK : STEP 3' );
				// NOW CALL API to send SETTINGS
				if ( ! class_exists( 'JooviiCouriersplease_Shipping_Method' ) )
				{
					JooviiCouriersplease_Shipping_Method();
					$Jooviiobj = new JooviiCouriersplease_Shipping_Method;
					$Jooviiobj->JooviiCouriersplease_webapp_sync_store();
				    Joovii_couriersplease_log_actions('INSIDE UPGRADE COMPLETE HOOK : SYNC Phase Success' );
				}

				// set transient to let it run later.
				// set_transient('JooviiCouriersplease_joovii_plugin_just_updated', 1);
			} else {
				Joovii_couriersplease_log_actions('INSIDE UPGRADE COMPLETE HOOK : STEP 4' );
			}
		}
	}// endif; $hook_extra

	Joovii_couriersplease_log_actions('INSIDE UPGRADE COMPLETE HOOK : STEP 5' );
}
