<?php

function JooviiCouriersplease_trackingemailtemplate() {

	$defaultValue = '
	Hi {{customer_name}}
	An order you recently placed on our website has had its status changed.

	The status of order #{{order_no}} is now Shipped

	Shipment Tracking Numbers: {{tracking_number}}
	Shipment Tracking Links : {{tracking_link}}

	{{store_name}}';

	$nonce = isset($_REQUEST['_wpnonce']) ? sanitize_text_field($_REQUEST['_wpnonce']) : '';

	if ( '' != $nonce && ! wp_verify_nonce( $nonce, 'joovi-wpcouriersplease-shipping-nonce' ) ) {
		 die( 'Security check Failed' );
	}

	if (isset($_POST['joovii_couriersplease_tracking_email_template'])) {
		$postemailTemplateVal = sanitize_textarea_field($_POST['joovii_couriersplease_tracking_email_template']);
	} else {
		$postemailTemplateVal='';
	}

	$emailTemplateVal = get_option('woocommerce_JooviiCouriersplease_tracking_email_template');

	if (''!=trim($postemailTemplateVal)) {

		$emailTemplateVal = $postemailTemplateVal;

		if (''!=trim(get_option('woocommerce_JooviiCouriersplease_tracking_email_template'))) {
			update_option( 'woocommerce_JooviiCouriersplease_tracking_email_template', $emailTemplateVal );
		} else {
			add_option( 'woocommerce_JooviiCouriersplease_tracking_email_template', $emailTemplateVal );
		}

	} else {

		if (''!=trim(get_option('woocommerce_JooviiCouriersplease_tracking_email_template'))) {
			$emailTemplateVal = $emailTemplateVal;
		} else {
			$emailTemplateVal = $defaultValue;
		}
	}

	$action = isset($_SERVER['REQUEST_URI'])? sanitize_text_field($_SERVER['REQUEST_URI']) : '';
	$nonce = wp_create_nonce( 'joovi-wpcouriersplease-shipping-nonce' );
	?>
	<form method="post" action="<?php echo esc_url($action); ?>&_nonce=<?php echo esc_html($nonce); ?>" enctype="multipart/form-data">
		<input type="hidden" name="rate" value="calculate">
		<div class="wrap">
			<h3 style="text-decoration:underline">Joovii Couriersplease Tracking Email Template</h3>
		</div>
		<table cellpadding="0" cellspacing="0" border="0"  width="100%" >
		<tr>
			<td>
				<textarea rows="15" cols="120" name="joovii_couriersplease_tracking_email_template"><?php echo esc_html($emailTemplateVal); ?></textarea>
			</td>
		</tr>
		<tr>
			<td align="left">&nbsp;<br><input type='submit' name="Save" value='Save' class='button'></td>
		</tr>
			<tr>
			<td align="left">&nbsp;<br><b>Following is the default email template.</b></td>
		</tr>
		<tr>
			<td align="left">&nbsp;<br> <?php echo nl2br(esc_html($defaultValue)); ?> </td>
		</tr>
		</table>
	</form>
<?php
}
?>
