<?php
/**
 * This file Updates Shipment against Orders
 *
 * @package joovii-couriersplease-shipping
 *
 * @link https://joovii.com
 *
 * PHP version : 7.2.1
 */
error_reporting(0);
define('WP_USE_THEMES', false);

$wp_load_path = dirname(__FILE__, 4) . '/wp-blog-header.php';

if( file_exists('../../../wp-blog-header.php') )
{
	require('../../../wp-blog-header.php');
}
else if( file_exists($wp_load_path))
{
	require($wp_load_path);
}
else if( file_exists('/opt/bitnami/wordpress/wp-blog-header.php') )
{
	require('/opt/bitnami/wordpress/wp-blog-header.php');
}
else 
{
	die("File Not Found");
}

$input = file_get_contents('php://input');

if ('' == $input) {
	Joovii_couriersplease_return_msg(100,'Input Data Missing');
}

$data = json_decode($input, true);

Joovii_couriersplease_shipment_update_log("Shipment-update STARTED");

if (is_array($data) && isset($data['security_code']) && ''!=$data['security_code'] &&
	isset($data['order_id']) && ''!=$data['order_id']) {
	
	Joovii_couriersplease_shipment_update_log("Shipment-update Step 1");
	$security_code = $data['security_code'];
	$st = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));
	if (is_array($st) && count($st) ) {
		if (isset($st['accesstoken']) && ''!=$st['accesstoken']) {
			if (md5($security_code)!=$st['accesstoken']) {
				Joovii_couriersplease_return_msg(101, 'Access Token Mismatch');
			}
		} else {
			Joovii_couriersplease_return_msg(102, 'Access Token Missing in Woo Store');
		}
	} else {
		Joovii_couriersplease_return_msg(103, 'Access Token Missing in Woo Store');
	}

	Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE DATA 54 :: ' .print_r($data, true));
	$hpos_enabled = 0;

	if (class_exists(\Automattic\WooCommerce\Utilities\OrderUtil::class) ) {
		if (\Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled() ) {
			$hpos_enabled  = 1;
		}
	}
	Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE HPOS_ENABLED 62 :: ' .$hpos_enabled);
	$order_id = $data['order_id'];
	if ($hpos_enabled) {
		$orderitem = wc_get_order($order_id);
		if ($orderitem ) {
			
			$receiver_email   = $orderitem->get_billing_email();
			$receiver_name    = $orderitem->get_shipping_first_name() . ' ' .
								$orderitem->get_shipping_last_name();
			
			if (isset($data['shipment_order_id'])) {
				$orderitem->update_meta_data('joovii_couriersplease_order_id', $data['shipment_order_id']);
			}
			
			if (isset($data['shipment_post'])) {
				$orderitem->update_meta_data('joovii_couriersplease_post', $data['shipment_post']);
			}
			
			if (isset($data['shipment_reference'])) {
				$orderitem->update_meta_data('joovii_couriersplease_reference', $data['shipment_reference']);
			}
			
			if (isset($data['shipment_response'])) {
				$orderitem->update_meta_data('joovii_couriersplease_response', $data['shipment_response']);
			}
			
			if (isset($data['shipment_tracking_url'])) {
				$orderitem->update_meta_data('joovii_couriersplease_tracking_url', $data['shipment_tracking_url']);
			}
			
			if (isset($data['label_url'])) {
				$orderitem->update_meta_data('joovii_couriersplease_label_url', $data['label_url']);
			}
			
			$orderitem->save();
			
			if (isset($data['shipment_response'])) {
				Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE 106 SHIPMENT_RESPONSE  :: ' . $data['shipment_response']);
				$joovii_couriersplease_response = json_decode(stripslashes($data['shipment_response']), true);
	            Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE 108 JOOVII_COURIERSPLEASE_RESPONSE  :: ' . print_r($joovii_couriersplease_response, true));
				JooviiCouriersplease_Send_Tracking_email($order_id, $receiver_email, $receiver_name, $data, 1);
			}
			Joovii_couriersplease_return_msg(0, 'Order Updated');
		} else {
			Joovii_couriersplease_return_msg(104, 'Order Not Found');
		}
	} else {
		$orderitem = get_post($order_id);
		if ($orderitem) {
			Joovii_couriersplease_shipment_update_log("Shipment-update Step 3");
			$receiver_email = get_post_meta($order_id, '_billing_email', true);
			$receiver_name  = get_post_meta($order_id, '_shipping_first_name', true)
							. ' ' . get_post_meta($order_id, '_shipping_last_name', true);

			if (isset($data['shipment_order_id'])) {
				update_post_meta($order_id, 'joovii_couriersplease_order_id', $data['shipment_order_id']);
			}
			if (isset($data['shipment_post'])) {
				update_post_meta($order_id, 'joovii_couriersplease_post', $data['shipment_post']);
			}
			if (isset($data['shipment_reference'])) {
				update_post_meta($order_id, 'joovii_couriersplease_reference', $data['shipment_reference']);
			}
			if (isset($data['shipment_response'])) {
				update_post_meta($order_id, 'joovii_couriersplease_response', $data['shipment_response']);
			}
			if (isset($data['shipment_tracking_url'])) {
				update_post_meta($order_id, 'joovii_couriersplease_tracking_url', $data['shipment_tracking_url']);
			}
			if (isset($data['label_url'])) {
				update_post_meta($order_id, 'joovii_couriersplease_label_url', $data['label_url']);
			}

			Joovii_couriersplease_shipment_update_log('Shipment Details Updated', $order_id);
			
			if (isset($data['shipment_response'])) {
				
			Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE 139 SHIPMENT_RESPONSE  :: ' .$data['shipment_response']);
			$joovii_couriersplease_response = json_decode(stripslashes($data['shipment_response']), true);
			Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE 141 JOOVII COURIERSPLEASE RESPONSE  :: ' .print_r($joovii_couriersplease_response, true));	
			JooviiCouriersplease_Send_Tracking_email($order_id, $receiver_email, $receiver_name, $data, 2);
			}

			Joovii_couriersplease_return_msg(0, 'Order Updated ....');
		} else {
			Joovii_couriersplease_return_msg(105, 'Order Not Found');
		}
	}
} else {
	Joovii_couriersplease_return_msg(106, '-Unauthorized-'); 
}


/**
 * This function sends tracking emails
 *
 * @param Integer $order_id
 *
 * @param  String $receiver_email
 *
 * @param  String $receiver_name
 *
 * @param $response
 *
 * @return void
 */
function JooviiCouriersplease_Send_Tracking_email($order_id, $receiver_email, $receiver_name, $response, $mode = '') {

	$site_url = home_url();
	$joovii_couriersplease_setting = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));

	$reference = isset($response['shipment_reference']) ? $response['shipment_reference'] : '';
	
	if($reference == '')
	{
		$reference = isset($response['couriersplease_reference']) ? $response['couriersplease_reference'] : '';
	}
	Joovii_couriersplease_shipment_update_log(' HOOK PAGE Reference  :: ' . $reference, $order_id);
	
	
	$tracking_url = isset($response['shipment_tracking_url']) ? $response['shipment_tracking_url'] : '';
	if($tracking_url == '')
	{
		$tracking_url = isset($response['tracking_url']) ? $response['tracking_url'] : '';
	}
	Joovii_couriersplease_shipment_update_log(' HOOK PAGE Tracking_url  :: ' . $tracking_url, $order_id);
	
	// GET LAST email STATUS
	$sent = '';
	$orderitem = '';
	if( $mode == 1 )
	{
		$orderitem = wc_get_order($order_id);
		if( $orderitem )
		{
			$sent = $orderitem->get_meta('shipment_email_sent');
		}
	}
	else if( $mode == 2 )
	{
		$orderitem = get_post($order_id);
		if( $orderitem )
		{
			$sent = get_post_meta($order_id, 'shipment_email_sent', true);
		}
	}
	
	Joovii_couriersplease_shipment_update_log("SHIPMENT-UPDATE Inside JooviiCouriersplease_Send_Tracking_email FUNCTION, [Sent:$sent] [Track Email Settings : " . 
	$joovii_couriersplease_setting['tracking_email'] . "]", $order_id);
	
	if ('yes' == $joovii_couriersplease_setting['tracking_email'] && $sent == '') 
	{
		
		// Update the Option 
		if( $mode == 1 )
		{
			if( $orderitem )
			{
				$orderitem->update_meta_data('shipment_email_sent', 'Yes');
				$orderitem->update_meta_data('shipment_email_sent_on', date("Y-m-d", time()) );
				Joovii_couriersplease_shipment_update_log("SHIPMENT-UPDATE Inside JooviiCouriersplease_Send_Tracking_email, Updated Order Meta : Mode $mode", $order_id);
			}
		}
		else if( $mode == 2 )
		{
			if( $orderitem )
			{
				update_post_meta($order_id, 'shipment_email_sent', 'Yes');
				update_post_meta($order_id, 'shipment_email_sent_on', date("Y-m-d", time()) );
				Joovii_couriersplease_shipment_update_log("SHIPMENT-UPDATE Inside JooviiCouriersplease_Send_Tracking_email, Updated Order Meta : Mode $mode", $order_id);
			}
		}
	
		$default_emailTemplateVal = '
		Hi {{customer_name}}
		An order you recently placed on our website has had its status changed.

		The status of order #{{order_no}} is now Shipped

		Shipment Tracking Numbers: {{tracking_number}}
		Shipment Tracking Links : {{tracking_link}}

		{{store_name}}';

		$to = $receiver_email;
		$subject = 'Your Order Has Been Updated (#' . $order_id . ')';
		$emailTemplateVal = get_option('woocommerce_JooviiCouriersplease_tracking_email_template');
		if ('' == trim($emailTemplateVal)) {
			$emailTemplateVal = $default_emailTemplateVal;
		}
		$body = str_replace('{{customer_name}}', ucwords($receiver_name), $emailTemplateVal);
		$body = str_replace('{{order_no}}', $order_id, $body);
		$body = str_replace('{{tracking_number}}', $reference, $body);
		$body = str_replace('{{tracking_link}}', $tracking_url, $body);
		$body = nl2br($body);
		$body = str_replace('{{store_name}}', $site_url, $body);

		$site_title = get_bloginfo('name');
		$site_admin_email = get_bloginfo('admin_email');


		$headers = array('Content-Type: text/html; charset=UTF-8');
		$headers[] = 'From: ' . $site_title . '<' . $site_admin_email . '>';

		wp_mail($to, $subject, $body, $headers);

		Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE Response  :: ' . print_r($response), $order_id);
		Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE tracking email sent [' . $to . ']  :: ' . $order_id, $order_id);
		Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE tracking email sent [subject] :: ' . $subject, $order_id);
		Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE tracking email sent [body] :: ' . $body, $order_id);
		Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE tracking email sent [header] :: ->' . $site_title . '--' .
									$site_admin_email . '<---', $order_id);
		Joovii_couriersplease_shipment_update_log(' SHIPMENT-UPDATE tracking email sent [emailTemplateVal] :: ' . $emailTemplateVal, $order_id);

		// UPDATE the ORDER 
		$orderitem = new WC_Order($order_id);
		
		if ('processing'==$joovii_couriersplease_setting['change_order_status']) 
		{
			$orderitem->update_status('processing');
			Joovii_couriersplease_shipment_update_log(' update order status to processing :: ' . $order_id, $order_id);
		}
		
		if ('completed'==$joovii_couriersplease_setting['change_order_status']) 
		{
			$orderitem->update_status('completed');
			Joovii_couriersplease_shipment_update_log(' update order status to completed :: ' . $order_id, $order_id);
		}
	
	}
	//Joovii_couriersplease_shipment_update_log('Order submitted from ' . $joovii_couriersplease_setting['book_shipment_on'].' completed.' .$postedby, $order_id);

}

/**
 * This function Updates the LOG
 *
 * @param  String $message
 *
 * @param  Integer $order_id
 *
 * @return void
 */
function Joovii_couriersplease_shipment_update_log($message, $orderid = '0') {
	$joovii_couriersplease_setting = maybe_unserialize(get_option('woocommerce_jooviicouriersplease_settings'));
	if ('yes'==$joovii_couriersplease_setting['enable_log']) {
		global $wpdb;
		$table_name = $wpdb->prefix . 'joovii_courierspleaselogs';
		$wp_timezone = get_option('timezone_string');
		$wp_timezone = ( ''==$wp_timezone?'Australia/Sydney':$wp_timezone );
		$tz = new DateTimeZone($wp_timezone);
		$currentDateTime = new DateTime('now', $tz);
		$date = $currentDateTime->format('Y-m-d H:i:s');
		$wpdb->insert($table_name, array(
						'eventname'=>'null', 
						'orderid'=>$orderid,
						'logs'=>$message, 
						'timestamp'=> $date), 
						array('%s', '%d', '%s'));
	}
}

/**
 * This function Updates the LOG
 *
 * @param  Integer $err
 *
 * @param  String $msg
 *
 * @return void
 */
function Joovii_couriersplease_return_msg($err, $msg) {
	echo json_encode(['err' => $err, 'msg' => $msg]);
	die();
}
